/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorFileSystemProvider;

public class Validator {
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found. Consequentially validation cannot be performed.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private final ValidatorFileSystemProvider validatorFileSystemProvider;
    protected final List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
    private final KieBuilder kieBuilder;

    public Validator(ValidatorFileSystemProvider validatorFileSystemProvider) {
        this.validatorFileSystemProvider = validatorFileSystemProvider;
        this.kieBuilder = this.makeKieBuilder();
    }

    protected KieBuilder makeKieBuilder() {
        return KieServices.Factory.get().newKieBuilder(this.validatorFileSystemProvider.getFileSystem());
    }

    public List<ValidationMessage> validate() {
        this.validatorFileSystemProvider.write();
        this.runValidation();
        return this.validationMessages;
    }

    public KieBuilder getKieBuilder() {
        return this.kieBuilder;
    }

    private void runValidation() {
        try {
            String destinationBasePath = this.getBasePath(this.validatorFileSystemProvider.getDestinationPath());
            for (Message message : this.getBuildMessages()) {
                this.addMessage(destinationBasePath, message);
            }
        }
        catch (NoClassDefFoundError e) {
            this.validationMessages.add(this.makeErrorMessage(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage())));
        }
        catch (Throwable e) {
            this.validationMessages.add(this.makeErrorMessage(e.getLocalizedMessage()));
        }
    }

    protected void addMessage(String destinationBasePath, Message message) {
        String messageBasePath = this.getMessagePath(message);
        if (messageBasePath == null || "".equals(messageBasePath) || destinationBasePath.endsWith(messageBasePath)) {
            this.validationMessages.add(this.convertMessage(message));
        }
    }

    private List<Message> getBuildMessages() {
        return this.kieBuilder.buildAll().getResults().getMessages();
    }

    private String getMessagePath(Message message) {
        return message.getPath() != null ? this.getBasePath(message.getPath()) : null;
    }

    private String getBasePath(String path) {
        if (path != null && path.contains(".")) {
            return path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private ValidationMessage makeErrorMessage(String msg) {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setLevel(Level.ERROR);
        validationMessage.setText(msg);
        return validationMessage;
    }

    protected ValidationMessage convertMessage(Message message) {
        ValidationMessage msg = new ValidationMessage();
        switch (message.getLevel()) {
            case ERROR: {
                msg.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                msg.setLevel(Level.WARNING);
                break;
            }
            case INFO: {
                msg.setLevel(Level.INFO);
            }
        }
        msg.setId(message.getId());
        msg.setLine(message.getLine());
        msg.setColumn(message.getColumn());
        msg.setText(message.getText());
        return msg;
    }
}

