/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractProjectService;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.project.KieProjectFactory;
import org.kie.workbench.common.services.backend.project.KieResourceResolver;
import org.kie.workbench.common.services.backend.project.ProjectSaver;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class KieProjectServiceImpl
extends AbstractProjectService<KieProject>
implements KieProjectFactory,
KieProjectService {
    private ProjectSaver projectSaver;
    private ProjectRepositoryResolver repositoryResolver;

    public KieProjectServiceImpl() {
    }

    @Inject
    public KieProjectServiceImpl(@Named(value="ioStrategy") IOService ioService, ProjectSaver projectSaver, POMService pomService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, SessionInfo sessionInfo, AuthorizationManager authorizationManager, BackwardCompatibleUtil backward, CommentedOptionFactory commentedOptionFactory, KieResourceResolver resourceResolver, ProjectRepositoryResolver repositoryResolver) {
        super(ioService, pomService, configurationService, configurationFactory, newProjectEvent, newPackageEvent, renameProjectEvent, invalidateDMOCache, sessionInfo, authorizationManager, backward, commentedOptionFactory, (ResourceResolver)resourceResolver);
        this.projectSaver = projectSaver;
        this.repositoryResolver = repositoryResolver;
    }

    public KieProject newProject(org.uberfire.backend.vfs.Path repositoryPath, POM pom, String baseUrl) {
        return this.newProject(repositoryPath, pom, baseUrl, DeploymentMode.VALIDATED);
    }

    public KieProject newProject(org.uberfire.backend.vfs.Path repositoryPath, POM pom, String baseUrl, DeploymentMode mode) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pom);
        }
        return this.projectSaver.save(repositoryPath, pom, baseUrl);
    }

    private void checkRepositories(POM pom) {
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pom.getGav(), new MavenRepositoryMetadata[0]);
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }

    public KieProject simpleProjectInstance(Path nioProjectRootPath) {
        return (KieProject)this.resourceResolver.simpleProjectInstance(nioProjectRootPath);
    }

    public KieProject resolveProject(org.uberfire.backend.vfs.Path resource) {
        return (KieProject)this.resourceResolver.resolveProject(resource);
    }

    public Project resolveParentProject(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveParentProject(resource);
    }

    public Project resolveToParentProject(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveToParentProject(resource);
    }

    public Set<Package> resolvePackages(Project project) {
        return this.resourceResolver.resolvePackages(project);
    }

    public Set<Package> resolvePackages(Package pkg) {
        return this.resourceResolver.resolvePackages(pkg);
    }

    public Package resolveDefaultPackage(Project project) {
        return this.resourceResolver.resolveDefaultPackage(project);
    }

    public Package resolveParentPackage(Package pkg) {
        return this.resourceResolver.resolveParentPackage(pkg);
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.isPom(resource);
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolvePackage(resource);
    }
}

