/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.validation.JavaFileNameValidator;
import org.kie.workbench.common.services.backend.validation.PackageNameValidator;
import org.kie.workbench.common.services.backend.validation.ProjectNameValidator;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.backend.validation.ValidationUtils;

@Service
@ApplicationScoped
public class ValidationServiceImpl
implements ValidationService {
    private org.uberfire.ext.editor.commons.service.ValidationService validationService;
    private PackageNameValidator packageNameValidator;
    private ProjectNameValidator projectNameValidator;
    private JavaFileNameValidator javaFileNameValidator;

    public ValidationServiceImpl() {
    }

    @Inject
    public ValidationServiceImpl(org.uberfire.ext.editor.commons.service.ValidationService validationService, PackageNameValidator packageNameValidator, ProjectNameValidator projectNameValidator, JavaFileNameValidator javaFileNameValidator) {
        this.validationService = validationService;
        this.packageNameValidator = packageNameValidator;
        this.projectNameValidator = projectNameValidator;
        this.javaFileNameValidator = javaFileNameValidator;
    }

    public boolean isProjectNameValid(String projectName) {
        return this.projectNameValidator.isValid(projectName);
    }

    public boolean isPackageNameValid(String packageName) {
        return this.packageNameValidator.isValid(packageName);
    }

    public boolean isFileNameValid(Path path, String fileName) {
        return this.validationService.isFileNameValid(path, fileName);
    }

    public boolean isJavaFileNameValid(String fileName) {
        return this.javaFileNameValidator.isValid(fileName);
    }

    public boolean isFileNameValid(String fileName) {
        return this.validationService.isFileNameValid(fileName);
    }

    public Map<String, Boolean> evaluateJavaIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isJavaIdentifier((String)s));
            }
        }
        return result;
    }

    public Map<String, Boolean> evaluateMavenIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isArtifactIdentifier((String)s));
            }
        }
        return result;
    }

    public boolean isTimerIntervalValid(String timerInterval) {
        try {
            TimeIntervalParser.parse((String)timerInterval);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean validate(POM pom) {
        PortablePreconditions.checkNotNull((String)"pom", (Object)pom);
        String name = pom.getName();
        String groupId = pom.getGav().getGroupId();
        String artifactId = pom.getGav().getArtifactId();
        String version = pom.getGav().getVersion();
        boolean validName = name != null && !name.isEmpty() && this.isProjectNameValid(name);
        boolean validGroupId = this.validateGroupId(groupId);
        boolean validArtifactId = this.validateArtifactId(artifactId);
        boolean validVersion = this.validateGAVVersion(version);
        return validName && validGroupId && validArtifactId && validVersion;
    }

    public boolean validateGroupId(String groupId) {
        String[] groupIdComponents = groupId == null ? new String[]{} : groupId.split("\\.", -1);
        boolean validGroupId = groupIdComponents.length != 0 && !this.evaluateMavenIdentifiers(groupIdComponents).containsValue(Boolean.FALSE);
        return validGroupId;
    }

    public boolean validateArtifactId(String artifactId) {
        String[] artifactIdComponents = artifactId == null ? new String[]{} : artifactId.split("\\.", -1);
        boolean validArtifactId = artifactIdComponents.length != 0 && !this.evaluateMavenIdentifiers(artifactIdComponents).containsValue(Boolean.FALSE);
        return validArtifactId;
    }

    public boolean validateGAVVersion(String version) {
        boolean validVersion = version != null && !version.isEmpty() && version.matches("^[a-zA-Z0-9\\.\\-_]+$");
        return validVersion;
    }
}

