/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.service;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.kie.workbench.common.services.backend.builder.ala.BuildPipelineInvoker;
import org.kie.workbench.common.services.backend.builder.ala.LocalBinaryConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.core.DeploymentVerifier;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class BuildServiceHelper {
    private BuildPipelineInvoker buildPipelineInvoker;
    private DeploymentVerifier deploymentVerifier;

    public BuildServiceHelper() {
    }

    @Inject
    public BuildServiceHelper(BuildPipelineInvoker buildPipelineInvoker, DeploymentVerifier deploymentVerifier) {
        this.buildPipelineInvoker = buildPipelineInvoker;
        this.deploymentVerifier = deploymentVerifier;
    }

    public BuildResults localBuild(Project project) {
        BuildResults[] result = new BuildResults[1];
        this.invokeLocalBuildPipeLine(project, localBinaryConfig -> {
            result[0] = localBinaryConfig.getBuildResults();
        });
        return result[0];
    }

    public void localBuild(Project project, Consumer<LocalBinaryConfig> consumer) {
        this.invokeLocalBuildPipeLine(project, consumer);
    }

    public IncrementalBuildResults localBuild(Project project, LocalBuildConfig.BuildType buildType, Path resource) {
        IncrementalBuildResults[] result = new IncrementalBuildResults[1];
        this.invokeLocalBuildPipeLine(project, buildType, resource, (LocalBinaryConfig localBinaryConfig) -> {
            result[0] = localBinaryConfig.getIncrementalBuildResults();
        });
        return result[0];
    }

    public IncrementalBuildResults localBuild(Project project, Map<Path, Collection<ResourceChange>> resourceChanges) {
        IncrementalBuildResults[] result = new IncrementalBuildResults[1];
        this.invokeLocalBuildPipeLine(project, resourceChanges, localBinaryConfig -> {
            result[0] = localBinaryConfig.getIncrementalBuildResults();
        });
        return result[0];
    }

    public BuildResults localBuildAndDeploy(Project project, DeploymentMode mode, boolean suppressHandlers) {
        BuildResults[] result = new BuildResults[1];
        this.invokeLocalBuildPipeLine(project, suppressHandlers, mode, (LocalBinaryConfig localBinaryConfig) -> {
            result[0] = localBinaryConfig.getBuildResults();
        });
        return result[0];
    }

    private void invokeLocalBuildPipeLine(Project project, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newFullBuildRequest(project);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Project project, LocalBuildConfig.BuildType buildType, Path resource, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newIncrementalBuildRequest(project, buildType, resource);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Project project, Map<Path, Collection<ResourceChange>> resourceChanges, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newIncrementalBuildRequest(project, resourceChanges);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Project project, boolean suppressHandlers, DeploymentMode mode, Consumer<LocalBinaryConfig> consumer) {
        this.deploymentVerifier.verifyWithException(project, mode);
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newFullBuildAndDeployRequest(project, this.toDeploymentType(mode), suppressHandlers);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private LocalBuildConfig.DeploymentType toDeploymentType(DeploymentMode deploymentMode) {
        return deploymentMode == DeploymentMode.VALIDATED ? LocalBuildConfig.DeploymentType.VALIDATED : LocalBuildConfig.DeploymentType.FORCED;
    }
}

