/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.pom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.kie.workbench.common.services.backend.pom.DependenciesCollection;
import org.kie.workbench.common.services.backend.pom.DependencyKey;
import org.kie.workbench.common.services.backend.pom.JSONDTO;
import org.kie.workbench.common.services.backend.pom.PluginPresence;
import org.kie.workbench.common.services.backend.pom.PomJsonReader;
import org.kie.workbench.common.services.backend.pom.RepositoryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class PomEditor
implements PomEnhancer {
    private static final String PROPERTIES_FILE = "PomMigration.properties";
    private static final String JSON_POM_MIGRATION = "pom-migration.json";
    private static final String JSON_POM_MANDATORY_DEPS = "pom-mandatory.json";
    private static final String KIE_VERSION_KEY = "KIE_VERSION";
    private static final String KIE_PKG = "org.kie";
    private static final String JBPM_PKG = "org.jbpm";
    private static final String DROOLS_PKG = "org.drools";
    private static final String OPTAPLANNER_PKG = "org.optaplanner";
    private static final String KJAR_PKG = "kjar";
    private static final String POM_PKG = "pom";
    private static final String KIE_MAVEN_PLUGIN_ARTIFACT_ID = "kie-maven-plugin";
    private final Logger logger = LoggerFactory.getLogger(PomEditor.class);
    private MavenXpp3Reader reader = new MavenXpp3Reader();
    private MavenXpp3Writer writer = new MavenXpp3Writer();
    private String kieVersion;
    private JSONDTO jsonConf;
    private PomJsonReader jsonReader;
    private PomJsonReader jsonMandatoryDepsReader;
    private Properties props = this.loadProperties("PomMigration.properties");

    public PomEditor() {
        this.jsonMandatoryDepsReader = new PomJsonReader(this.getClass().getClassLoader().getResourceAsStream(JSON_POM_MANDATORY_DEPS));
        this.kieVersion = this.props.getProperty(KIE_VERSION_KEY);
        if (this.kieVersion == null) {
            throw new RuntimeException("Kie version missing in configuration files");
        }
    }

    public Model execute(Model model) {
        try {
            this.process(model);
            return model;
        }
        catch (Exception e) {
            System.err.println("Error occurred during POMs migration:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            return new Model();
        }
    }

    private void process(Model model) {
        Build build = this.getBuild(model);
        this.updatePackaging(model);
        this.updateBuildTag(build);
        this.updateDependenciesTag(model);
        this.updateRepositories(model);
        this.updatePluginRepositories(model);
    }

    public Model updatePomWithoutWrite(Path pom) {
        try {
            Model model = this.getModel(pom);
            this.process(model);
            return model;
        }
        catch (Exception e) {
            System.err.println("Error occurred during POMs migration:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            return new Model();
        }
    }

    public Model updatePomWithoutWrite(Path pom, String pathJsonFile) {
        try {
            Model model = this.getModel(pom);
            this.jsonReader = new PomJsonReader(pathJsonFile, JSON_POM_MIGRATION);
            this.jsonConf = this.jsonReader.readDepsAndRepos(model);
            this.process(model);
            return model;
        }
        catch (Exception e) {
            System.err.println("Error occurred during POMs migration:" + e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            return new Model();
        }
    }

    private void updatePackaging(Model model) {
        String packaging = model.getPackaging();
        if (!(packaging == POM_PKG || packaging != null && packaging.equals(KJAR_PKG))) {
            model.setPackaging(KJAR_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String propName) {
        Properties prop = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(propName);
        if (in == null) {
            this.logger.info("{} not available with the classloader, skip to the next ConfigurationStrategy. \n", (Object)propName);
        } else {
            try {
                prop.load(in);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    private void updateBuildTag(Build build) {
        List<Plugin> buildPlugins = this.getBuildPlugins(build);
        this.processKieMavenCompiler(buildPlugins);
    }

    private void processKieMavenCompiler(List<Plugin> buildPlugins) {
        PluginPresence kieMavenCompiler = this.getPluginPresence(buildPlugins, KIE_PKG, KIE_MAVEN_PLUGIN_ARTIFACT_ID);
        if (!kieMavenCompiler.isPresent()) {
            buildPlugins.add(this.getKieMavenPlugin());
        } else {
            Plugin kieMavenPlugin = buildPlugins.get(kieMavenCompiler.getPosition());
            kieMavenPlugin.setVersion(this.kieVersion);
        }
    }

    public Model getModel(byte[] bytez) throws Exception {
        return this.reader.read((InputStream)new ByteArrayInputStream(bytez));
    }

    public Model getModel(Path pom) throws IOException, XmlPullParserException {
        return this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)pom)));
    }

    private Build getBuild(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            model.setBuild(new Build());
            build = model.getBuild();
        }
        return build;
    }

    private PluginPresence getPluginPresence(List<Plugin> plugins, String groupID, String artifactID) {
        boolean result = false;
        int i = 0;
        for (Plugin plugin : plugins) {
            if (plugin.getGroupId().equals(groupID) && plugin.getArtifactId().equals(artifactID)) {
                result = true;
                break;
            }
            ++i;
        }
        return new PluginPresence(result, i);
    }

    private List<Plugin> getBuildPlugins(Build build) {
        return build.getPlugins();
    }

    private Plugin getKieMavenPlugin() {
        Plugin kieMavenPlugin = new Plugin();
        kieMavenPlugin.setGroupId(KIE_PKG);
        kieMavenPlugin.setArtifactId(KIE_MAVEN_PLUGIN_ARTIFACT_ID);
        kieMavenPlugin.setVersion(this.kieVersion);
        kieMavenPlugin.setExtensions(true);
        return kieMavenPlugin;
    }

    private void updateDependenciesTag(Model model) {
        DependenciesCollection coll = new DependenciesCollection();
        coll.addDependencies(this.jsonMandatoryDepsReader.readDeps().getDependencies());
        coll.addDependenciesKeys(this.getChangedCurrentDependencies(model.getDependencies()));
        model.setDependencies(coll.getAsDependencyList());
    }

    private List<DependencyKey> getChangedCurrentDependencies(List<Dependency> dependencies) {
        ArrayList<DependencyKey> newDeps = new ArrayList<DependencyKey>();
        for (Dependency dep : dependencies) {
            Dependency newDep = new Dependency();
            newDep.setGroupId(dep.getGroupId());
            newDep.setArtifactId(dep.getArtifactId());
            if (dep.getClassifier() != null) {
                newDep.setClassifier(dep.getClassifier());
            }
            if (dep.getVersion() == null && this.isKieGroupDependency(dep.getGroupId())) {
                newDep.setVersion(this.kieVersion);
            } else {
                newDep.setVersion(dep.getVersion());
            }
            if (dep.getScope() != null) {
                newDep.setScope(dep.getScope());
            }
            newDeps.add(new DependencyKey(newDep));
        }
        return newDeps;
    }

    private boolean isKieGroupDependency(String groupID) {
        return groupID.startsWith(KIE_PKG) || groupID.startsWith(OPTAPLANNER_PKG) || groupID.startsWith(DROOLS_PKG) || groupID.startsWith(JBPM_PKG);
    }

    private void updateRepositories(Model model) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        this.applyMigrationRepos(repos);
        model.setRepositories(repos);
    }

    private void applyMigrationRepos(List<Repository> repos) {
        if (this.jsonConf != null) {
            for (RepositoryKey repoFromJson : this.jsonConf.getRepositories()) {
                repos.add(repoFromJson.getRepository());
            }
        }
    }

    private void updatePluginRepositories(Model model) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        this.applyMigrationPluginRepos(repos);
        model.setPluginRepositories(repos);
    }

    private void applyMigrationPluginRepos(List<Repository> repos) {
        if (this.jsonConf != null) {
            for (RepositoryKey repoFromJson : this.jsonConf.getPluginRepositories()) {
                repos.add(repoFromJson.getRepository());
            }
        }
    }
}

