/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.scanner.KieModuleMetaData;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class EnumDropdownServiceImpl
implements EnumDropdownService {
    private static final Logger logger = LoggerFactory.getLogger(EnumDropdownServiceImpl.class);
    @Inject
    private BuildInfoService buildInfoService;
    @Inject
    private KieModuleService moduleService;
    @Inject
    private MVELEvaluator mvelEvaluator;

    public String[] loadDropDownExpression(Path resource, String[] valuePairs, String expression) {
        KieModule module = (KieModule)this.moduleService.resolveModule(resource);
        if (module == null) {
            logger.error("A Module could not be resolved for path '" + resource.toURI() + "'. No enums will be returned.");
            return null;
        }
        org.kie.api.builder.KieModule kieModule = this.buildInfoService.getBuildInfo((Module)module).getKieModuleIgnoringErrors();
        if (kieModule == null) {
            logger.error("A KieModule could not be resolved for path '" + resource.toURI() + "'. No enums will be returned.");
            return null;
        }
        ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)kieModule).getClassLoader();
        return this.loadDropDownExpression(classLoader, this.mvelEvaluator, valuePairs, expression);
    }

    protected String[] loadDropDownExpression(ClassLoader classLoader, MVELEvaluator mvelEvaluator, String[] valuePairs, String expression) {
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            for (String valuePair : valuePairs) {
                if (valuePair == null) {
                    return new String[0];
                }
                String[] pair = valuePair.split("=");
                if (pair.length == 1) {
                    String[] swap = new String[]{pair[0], ""};
                    pair = swap;
                }
                context.put(pair[0], pair[1]);
            }
            expression = (String)TemplateRuntime.eval((String)expression, context);
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pconf.setClassLoader(classLoader);
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)pctx);
            Object result = mvelEvaluator.executeExpression((Object)compiled, new HashMap());
            if (result instanceof String[]) {
                return (String[])result;
            }
            if (result instanceof List) {
                List l = (List)result;
                String[] xs = new String[l.size()];
                for (int i = 0; i < xs.length; ++i) {
                    Object el = l.get(i);
                    xs[i] = el.toString();
                }
                return xs;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

