/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.pom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.kie.workbench.common.services.backend.pom.DependencyKey;

public class DependenciesCollection {
    private HashSet<DependencyKey> keys = new HashSet();

    public void addDependencies(List<Dependency> deps) {
        for (Dependency dep : deps) {
            DependencyKey key = new DependencyKey(dep);
            this.keys.add(key);
        }
    }

    public void addDependenciesKeys(List<DependencyKey> deps) {
        this.keys.addAll(deps);
    }

    public List<Dependency> getAsDependencyList() {
        ArrayList<Dependency> deps = new ArrayList<Dependency>(this.keys.size());
        for (DependencyKey key : this.keys) {
            deps.add(key.getDependency());
        }
        return deps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DependenciesCollection{");
        sb.append("keys=").append(this.keys);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependenciesCollection)) {
            return false;
        }
        DependenciesCollection that = (DependenciesCollection)o;
        return Objects.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return Objects.hash(this.keys);
    }
}

