/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.DeploymentVerifier;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class BuildHelper {
    private static final Logger logger = LoggerFactory.getLogger(BuildHelper.class);
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private LRUBuilderCache cache;
    private KieProjectService projectService;
    private DeploymentVerifier deploymentVerifier;
    private Instance<User> identity;
    private Instance<PostBuildHandler> handlers;

    public BuildHelper() {
    }

    @Inject
    public BuildHelper(POMService pomService, ExtendedM2RepoService m2RepoService, KieProjectService projectService, DeploymentVerifier deploymentVerifier, LRUBuilderCache cache, Instance<PostBuildHandler> handlers, Instance<User> identity) {
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.projectService = projectService;
        this.deploymentVerifier = deploymentVerifier;
        this.cache = cache;
        this.handlers = handlers;
        this.identity = identity;
    }

    public BuildResult build(Project project) {
        try {
            this.cache.invalidateCache(project);
            Builder builder = this.cache.assertBuilder(project);
            BuildResults results = builder.build();
            BuildMessage infoMsg = new BuildMessage();
            infoMsg.setLevel(Level.INFO);
            infoMsg.setText(this.buildResultMessage(project, results).toString());
            results.addBuildMessage(0, infoMsg);
            return new BuildResult(builder, results);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new BuildResult(null, this.buildExceptionResults(e, project.getPom().getGav()));
        }
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            KieProject project = (KieProject)this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder((Project)project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.addResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            KieProject project = (KieProject)this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder((Project)project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.deleteResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return new IncrementalBuildResults();
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            return builder.updateResource(Paths.convert((Path)resource));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Map<Path, Collection<ResourceChange>> changes) {
        IncrementalBuildResults results = new IncrementalBuildResults();
        try {
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.applyBatchResourceChanges(changes);
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private StringBuffer buildResultMessage(Project project, BuildResults results) {
        StringBuffer message = new StringBuffer();
        message.append("Build of project '");
        message.append(project.getProjectName());
        message.append("' (requested by ");
        message.append(this.getIdentifier());
        message.append(") completed.\n");
        message.append(" Build: ");
        message.append(results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE");
        return message;
    }

    public BuildResults buildExceptionResults(Exception e, GAV gav) {
        BuildResults exceptionResults = new BuildResults(gav);
        BuildMessage exceptionMessage = new BuildMessage();
        exceptionMessage.setLevel(Level.ERROR);
        exceptionMessage.setText(e.getMessage());
        exceptionResults.addBuildMessage(exceptionMessage);
        return exceptionResults;
    }

    public BuildResults buildAndDeploy(Project project) {
        return this.buildAndDeploy(project, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, DeploymentMode mode) {
        this.deploymentVerifier.verifyWithException(project, mode);
        return this.doBuildAndDeploy(project, false);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers) {
        return this.buildAndDeploy(project, suppressHandlers, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers, DeploymentMode mode) {
        this.deploymentVerifier.verifyWithException(project, mode);
        return this.doBuildAndDeploy(project, suppressHandlers);
    }

    private BuildResults doBuildAndDeploy(Project project, boolean suppressHandlers) {
        try {
            BuildResults results = this.build(project).getBuildResults();
            StringBuffer message = new StringBuffer();
            message.append("Build of project '" + project.getProjectName() + "' (requested by " + this.getIdentifier() + ") completed.\n");
            message.append(" Build: " + (results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE"));
            POM pom = (POM)this.pomService.load(project.getPomXMLPath());
            if (results.getErrorMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                message.append(" Maven: SUCCESSFUL");
                if (!suppressHandlers) {
                    results.addParameter("RootPath", project.getRootPath().toURI());
                    for (PostBuildHandler handler : this.handlers) {
                        try {
                            handler.process(results);
                        }
                        catch (Exception e) {
                            logger.warn("PostBuildHandler {} failed due to {}", (Object)handler, (Object)e.getMessage());
                        }
                    }
                    message.append(" Deploy: " + (results.getErrorMessages().isEmpty() ? "SUCCESSFUL" : "FAILURE"));
                }
            }
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildExceptionResults(e, project.getPom().getGav());
        }
    }

    private String getIdentifier() {
        if (this.identity.isUnsatisfied()) {
            return "system";
        }
        try {
            return ((User)this.identity.get()).getIdentifier();
        }
        catch (ContextNotActiveException e) {
            return "system";
        }
    }

    public class BuildResult {
        private Builder builder;
        private BuildResults buildResults;
        private IncrementalBuildResults incrementalBuildResults;

        public BuildResult(Builder builder, BuildResults buildResults) {
            this.builder = builder;
            this.buildResults = buildResults;
        }

        public BuildResult(Builder builder, IncrementalBuildResults incrementalBuildResults) {
            this.builder = builder;
            this.incrementalBuildResults = incrementalBuildResults;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public BuildResults getBuildResults() {
            return this.buildResults;
        }

        public IncrementalBuildResults getIncrementalBuildResults() {
            return this.incrementalBuildResults;
        }
    }
}

