/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO;

import java.net.URI;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.uberfire.java.nio.file.Path;

public class InternalNIOWorkspaceCompilationInfo {
    protected Path prjPath;
    protected Path enhancedMainPomFile;
    protected URI remoteRepo;
    protected Git gitRepo;
    protected Boolean kiePluginPresent = Boolean.FALSE;

    public InternalNIOWorkspaceCompilationInfo(Path prjPath, URI remoteRepo, Git gitRepo) {
        this.prjPath = prjPath;
        this.remoteRepo = remoteRepo;
        this.gitRepo = gitRepo;
    }

    public InternalNIOWorkspaceCompilationInfo(Path prjPath) {
        this.prjPath = prjPath;
    }

    public Boolean lateAdditionEnhancedMainPomFile(Path enhancedPom) {
        if (this.enhancedMainPomFile == null && enhancedPom != null) {
            this.enhancedMainPomFile = enhancedPom;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionGitRepo(Git git) {
        if (this.gitRepo == null && git != null) {
            this.gitRepo = git;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionRemoteGitRepo(URI uri) {
        if (this.remoteRepo == null && uri != null) {
            this.remoteRepo = uri;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionKiePluginPresent(Boolean present) {
        if (this.kiePluginPresent == null && present != null) {
            this.kiePluginPresent = present;
            return Boolean.TRUE;
        }
        if (present != null) {
            this.kiePluginPresent = this.kiePluginPresent | present;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isKiePluginPresent() {
        return this.kiePluginPresent;
    }

    public Optional<Git> getGitRepo() {
        return Optional.ofNullable(this.gitRepo);
    }

    public Path getPrjPath() {
        return this.prjPath;
    }

    public Optional<Path> getEnhancedMainPomFile() {
        return Optional.ofNullable(this.enhancedMainPomFile);
    }

    public Optional<URI> getRemoteRepo() {
        return Optional.ofNullable(this.remoteRepo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkspaceCompilationInfo{");
        sb.append("prjPath:{").append(this.prjPath);
        sb.append("}, enhancedMainPomFile:{").append(this.enhancedMainPomFile);
        sb.append("}, remoteRepo:{").append(this.remoteRepo);
        sb.append('}');
        return sb.toString();
    }
}

