/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.InternalNIOJGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.InternalNIOOutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.impl.InternalNIODefaultMavenCompiler;

public class InternalNIOMavenCompilerFactory {
    private static Map<String, InternalNIOMavenCompiler> compilers = new ConcurrentHashMap<String, InternalNIOMavenCompiler>();

    private InternalNIOMavenCompilerFactory() {
    }

    public static InternalNIOMavenCompiler getCompiler(Decorator decorator) {
        InternalNIOMavenCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = InternalNIOMavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static InternalNIOMavenCompiler createAndAddNewCompiler(Decorator decorator) {
        InternalNIOMavenCompiler compiler;
        switch (decorator) {
            case NONE: {
                compiler = new InternalNIODefaultMavenCompiler();
                break;
            }
            case JGIT_BEFORE: {
                compiler = new InternalNIOJGITCompilerBeforeDecorator(new InternalNIODefaultMavenCompiler());
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new InternalNIOOutputLogAfterDecorator(new InternalNIODefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new InternalNIOJGITCompilerBeforeDecorator(new InternalNIOOutputLogAfterDecorator(new InternalNIODefaultMavenCompiler()));
                break;
            }
            default: {
                compiler = new InternalNIODefaultMavenCompiler();
            }
        }
        compilers.put(Decorator.NONE.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, InternalNIOMavenCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

