/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

public class InternalNIOMavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(InternalNIOMavenUtils.class);
    private static final String POM_NAME = "pom.xml";

    public static List<Artifact> resolveDependenciesFromMultimodulePrj(List<String> pomsPaths) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        ArrayList<Artifact> deps = new ArrayList<Artifact>();
        try {
            for (String pomx : pomsPaths) {
                Path pom = Paths.get((String)pomx, (String[])new String[0]);
                Model model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)pom)));
                if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
                    InternalNIOMavenUtils.createArtifacts(model.getDependencyManagement().getDependencies(), deps);
                }
                if (model.getDependencies() == null) continue;
                InternalNIOMavenUtils.createArtifacts(model.getDependencies(), deps);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return Collections.emptyList();
        }
        return deps;
    }

    private static void createArtifacts(List<Dependency> pomDeps, List<Artifact> deps) {
        if (pomDeps != null && pomDeps.size() > 0) {
            for (Dependency dep : pomDeps) {
                DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType(), dep.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler());
                deps.add((Artifact)artifact);
            }
        }
    }

    public static void searchPoms(Path file, List<String> pomsList) {
        try (DirectoryStream ds = Files.newDirectoryStream((Path)file.toAbsolutePath());){
            for (Path p : ds) {
                if (Files.isDirectory((Path)p, (LinkOption[])new LinkOption[0])) {
                    InternalNIOMavenUtils.searchPoms(p, pomsList);
                    continue;
                }
                if (!p.endsWith(POM_NAME)) continue;
                pomsList.add(p.toAbsolutePath().toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

