/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO.impl.kie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.configuration.KieDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOKieMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.kie.InternalNIOKieAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.kie.InternalNIOKieJGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.kie.InternalNIOKieOutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.internalNIO.impl.kie.InternalNIOKieDefaultMavenCompiler;

public class InternalNIOKieMavenCompilerFactory {
    private static Map<String, InternalNIOKieMavenCompiler> compilers = new ConcurrentHashMap<String, InternalNIOKieMavenCompiler>();

    private InternalNIOKieMavenCompilerFactory() {
    }

    public static InternalNIOKieMavenCompiler getCompiler(KieDecorator decorator) {
        InternalNIOKieMavenCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = InternalNIOKieMavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static InternalNIOKieMavenCompiler createAndAddNewCompiler(KieDecorator decorator) {
        InternalNIOKieMavenCompiler compiler;
        switch (decorator) {
            case NONE: {
                compiler = new InternalNIOKieDefaultMavenCompiler();
                break;
            }
            case KIE_AFTER: {
                compiler = new InternalNIOKieAfterDecorator(new InternalNIOKieDefaultMavenCompiler());
                break;
            }
            case KIE_AND_LOG_AFTER: {
                compiler = new InternalNIOKieAfterDecorator(new InternalNIOKieOutputLogAfterDecorator(new InternalNIOKieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE: {
                compiler = new InternalNIOKieJGITCompilerBeforeDecorator(new InternalNIOKieDefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new InternalNIOKieJGITCompilerBeforeDecorator(new InternalNIOKieOutputLogAfterDecorator(new InternalNIOKieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE_AND_KIE_AFTER: {
                compiler = new InternalNIOKieJGITCompilerBeforeDecorator(new InternalNIOKieAfterDecorator(new InternalNIOKieDefaultMavenCompiler()));
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new InternalNIOKieOutputLogAfterDecorator(new InternalNIOKieDefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_KIE_AND_LOG_AFTER: {
                compiler = new InternalNIOKieJGITCompilerBeforeDecorator(new InternalNIOKieAfterDecorator(new InternalNIOKieOutputLogAfterDecorator(new InternalNIOKieDefaultMavenCompiler())));
                break;
            }
            default: {
                compiler = new InternalNIOKieDefaultMavenCompiler();
            }
        }
        compilers.put(Decorator.NONE.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, InternalNIOKieMavenCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

