/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.kie.workbench.common.services.backend.compiler.AFClassLoaderProvider;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.configuration.MavenConfig;
import org.kie.workbench.common.services.backend.compiler.nio.NIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.DotFileFilter;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIODefaultCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIOMavenCompilerFactory;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIOMavenUtils;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIOWorkspaceCompilationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOClassLoaderProviderImpl
implements AFClassLoaderProvider {
    protected static final Logger logger = LoggerFactory.getLogger(NIOClassLoaderProviderImpl.class);
    protected final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    protected String JAVA_ARCHIVE_RESOURCE_EXT = ".jar";
    protected String FILE_URI = "file://";

    public static void searchCPFiles(Path file, List<String> classPathFiles, String ... extensions) {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(file.toAbsolutePath());){
            for (Path p : ds) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    NIOClassLoaderProviderImpl.searchCPFiles(p, classPathFiles, extensions);
                    continue;
                }
                if (!Stream.of(extensions).anyMatch(p.toString()::endsWith)) continue;
                classPathFiles.add(p.toAbsolutePath().toString());
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    @Override
    public Optional<ClassLoader> getClassloaderFromAllDependencies(String prjPath, String localRepo) {
        Optional<ClassLoader> urlClassLoader;
        StringBuilder sb;
        NIOWorkspaceCompilationInfo info;
        NIODefaultCompilationRequest req;
        NIOMavenCompiler compiler = NIOMavenCompilerFactory.getCompiler(Decorator.NONE);
        CompilationResponse res = compiler.compileSync(req = new NIODefaultCompilationRequest(localRepo, info = new NIOWorkspaceCompilationInfo(Paths.get(prjPath, new String[0])), new String[]{"dependency:build-classpath", (sb = new StringBuilder(MavenConfig.MAVEN_DEP_PLUGING_OUTPUT_FILE).append(MavenConfig.CLASSPATH_FILENAME).append(MavenConfig.CLASSPATH_EXT)).toString()}, new HashMap<String, Object>(), Boolean.FALSE));
        if (res.isSuccessful().booleanValue() && (urlClassLoader = this.createClassloaderFromCpFiles(prjPath)) != null) {
            return urlClassLoader;
        }
        return Optional.empty();
    }

    @Override
    public Optional<ClassLoader> loadDependenciesClassloaderFromProject(String prjPath, String localRepo) {
        ArrayList<String> poms = new ArrayList<String>();
        NIOMavenUtils.searchPoms(Paths.get(prjPath, new String[0]), poms);
        List<URL> urls = this.getDependenciesURL(poms, localRepo);
        return this.buildResult(urls);
    }

    @Override
    public Optional<ClassLoader> loadDependenciesClassloaderFromProject(List<String> poms, String localRepo) {
        List<URL> urls = this.getDependenciesURL(poms, localRepo);
        return this.buildResult(urls);
    }

    @Override
    public Optional<ClassLoader> getClassloaderFromProjectTargets(List<String> targets, Boolean loadIntoClassloader) {
        List<URL> urls = loadIntoClassloader != false ? this.getTargetModulesURL(targets) : this.getTargetModulesURL(targets);
        return this.buildResult(urls);
    }

    private List<URL> buildUrlsFromArtifacts(String localRepo, List<Artifact> artifacts) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(artifacts.size());
        for (Artifact artifact : artifacts) {
            StringBuilder sb = new StringBuilder("file://");
            sb.append(localRepo).append("/").append(artifact.getGroupId()).append("/").append(artifact.getVersion()).append("/").append(artifact.getArtifactId()).append("-").append(artifact.getVersion()).append(".").append(artifact.getType());
            URL url = new URL(sb.toString());
            urls.add(url);
        }
        return urls;
    }

    private List<URL> getDependenciesURL(List<String> poms, String localRepo) {
        List<Artifact> artifacts = NIOMavenUtils.resolveDependenciesFromMultimodulePrj(poms);
        List<URL> urls = Collections.emptyList();
        try {
            urls = this.buildUrlsFromArtifacts(localRepo, artifacts);
        }
        catch (MalformedURLException ex) {
            logger.error(ex.getMessage());
        }
        return urls;
    }

    private List<URL> getTargetModulesURL(List<String> pomsPaths) {
        if (pomsPaths != null && pomsPaths.size() > 0) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                for (String pomPath : pomsPaths) {
                    Path path = Paths.get(pomPath, new String[0]);
                    if (path == null) continue;
                    StringBuilder sb = new StringBuilder("file://").append(path.getParent().toAbsolutePath().toString()).append("/target/classes/");
                    urls.add(new URL(sb.toString()));
                }
            }
            catch (MalformedURLException ex) {
                logger.error(ex.getMessage());
            }
            return urls;
        }
        return Collections.emptyList();
    }

    private Optional<ClassLoader> buildResult(List<URL> urls) {
        if (urls.isEmpty()) {
            return Optional.empty();
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        return Optional.of(urlClassLoader);
    }

    private Optional<ClassLoader> buildResult(List<URL> urls, ClassLoader parent) {
        if (urls.isEmpty()) {
            return Optional.empty();
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        return Optional.of(urlClassLoader);
    }

    private Optional<ClassLoader> createClassloaderFromCpFiles(String prjPath) {
        List<URL> deps = this.readAllCpFilesAsUrls(prjPath, MavenConfig.CLASSPATH_EXT);
        if (deps.isEmpty()) {
            return Optional.empty();
        }
        URLClassLoader urlClassLoader = new URLClassLoader(deps.toArray(new URL[deps.size()]));
        return Optional.of(urlClassLoader);
    }

    private List<URL> readAllCpFilesAsUrls(String prjPath, String extension) {
        ArrayList<String> classPathFiles = new ArrayList<String>();
        NIOClassLoaderProviderImpl.searchCPFiles(Paths.get(prjPath, new String[0]), classPathFiles, extension);
        if (!classPathFiles.isEmpty()) {
            ArrayList<URL> deps = new ArrayList<URL>();
            for (String file : classPathFiles) {
                deps.addAll(this.readFileAsURL(file));
            }
            if (!deps.isEmpty()) {
                return deps;
            }
        }
        return Collections.emptyList();
    }

    private List<URL> loadFiles(List<String> pomsPaths) {
        List<URL> targetModulesUrls = this.getTargetModulesURL(pomsPaths);
        if (!targetModulesUrls.isEmpty()) {
            List<URL> targetFiles = this.addFilesURL(targetModulesUrls);
            return targetFiles;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URI> readFileAsURI(String filePath) {
        BufferedReader br = null;
        ArrayList<URI> urls = new ArrayList<URI>();
        try {
            String sCurrentLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            while ((sCurrentLine = br.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(sCurrentLine, ":");
                while (token.hasMoreTokens()) {
                    StringBuilder sb = new StringBuilder("file://").append(token.nextToken());
                    urls.add(new URI(sb.toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                Files.delete(Paths.get(filePath, new String[0]));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> readFileAsURL(String filePath) {
        BufferedReader br = null;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String sCurrentLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            while ((sCurrentLine = br.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(sCurrentLine, ":");
                while (token.hasMoreTokens()) {
                    StringBuilder sb = new StringBuilder("file://").append(token.nextToken());
                    urls.add(new URL(sb.toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                Files.delete(Paths.get(filePath, new String[0]));
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
        return urls;
    }

    @Override
    public Optional<List<URI>> getURISFromAllDependencies(String prjPath) {
        List<URI> deps;
        ArrayList<String> classPathFiles = new ArrayList<String>();
        NIOClassLoaderProviderImpl.searchCPFiles(Paths.get(prjPath, new String[0]), classPathFiles, MavenConfig.CLASSPATH_EXT, this.JAVA_ARCHIVE_RESOURCE_EXT);
        if (!classPathFiles.isEmpty() && !(deps = this.processScannedFiles(classPathFiles)).isEmpty()) {
            return Optional.of(deps);
        }
        return Optional.empty();
    }

    private List<URI> processScannedFiles(List<String> classPathFiles) {
        ArrayList<URI> deps = new ArrayList<URI>();
        for (String file : classPathFiles) {
            if (file.endsWith(MavenConfig.CLASSPATH_EXT)) {
                deps.addAll(this.readFileAsURI(file));
                continue;
            }
            if (!file.endsWith(this.JAVA_ARCHIVE_RESOURCE_EXT)) continue;
            deps.add(URI.create(this.FILE_URI + file));
        }
        return deps;
    }

    private List<URL> addFilesURL(List<URL> targetModulesUrls) {
        ArrayList<URL> targetFiles = new ArrayList<URL>(targetModulesUrls.size());
        for (URL url : targetModulesUrls) {
            try {
                targetFiles.addAll(this.visitFolders(Files.newDirectoryStream(Paths.get(url.toURI()))));
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
            catch (URISyntaxException ex) {
                logger.error(ex.getMessage());
            }
        }
        return targetFiles;
    }

    private List<URL> visitFolders(DirectoryStream<Path> directoryStream) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.visitFolders(Files.newDirectoryStream(path));
                    continue;
                }
                if (this.dotFileFilter.accept(path)) continue;
                try {
                    urls.add(path.toUri().toURL());
                }
                catch (MalformedURLException ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
        return urls;
    }
}

