/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.kie.workbench.common.services.backend.compiler.external339.AFCliRequest;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIOWorkspaceCompilationInfo;

public class NIODefaultCompilationRequest
implements NIOCompilationRequest {
    private AFCliRequest req;
    private NIOWorkspaceCompilationInfo info;
    private String requestUUID;
    private Map map;
    private String mavenRepo;

    public NIODefaultCompilationRequest(String mavenRepo, NIOWorkspaceCompilationInfo info, String[] args, Map<String, Object> map, Boolean logRequested) {
        this.mavenRepo = mavenRepo;
        this.info = info;
        this.map = map;
        this.requestUUID = UUID.randomUUID().toString();
        String[] internalArgs = this.getInternalArgs(args, logRequested);
        this.req = new AFCliRequest(info.getPrjPath().toAbsolutePath().toString(), internalArgs, this.map, this.requestUUID, logRequested);
    }

    public static Boolean isValidMavenRepo(Path mavenRepo) {
        if (mavenRepo.getParent() == null) {
            return Boolean.FALSE;
        }
        return Files.exists(mavenRepo, new LinkOption[0]) && Files.isDirectory(mavenRepo, new LinkOption[0]) && Files.isWritable(mavenRepo) && Files.isReadable(mavenRepo);
    }

    private String[] getInternalArgs(String[] args, Boolean logRequested) {
        String[] internalArgs;
        StringBuilder sbCompilationID = new StringBuilder().append("-Dcompilation.ID=").append(this.requestUUID);
        if (logRequested.booleanValue()) {
            StringBuilder sbLogID = new StringBuilder().append("-l ").append("log").append(".").append(this.requestUUID).append(".log");
            internalArgs = Arrays.copyOf(args, args.length + 2);
            internalArgs[args.length + 1] = sbLogID.toString();
        } else {
            internalArgs = Arrays.copyOf(args, args.length + 1);
        }
        internalArgs[args.length] = sbCompilationID.toString();
        return internalArgs;
    }

    @Override
    public NIOWorkspaceCompilationInfo getInfo() {
        return this.info;
    }

    public Optional<URI> getRepoURI() {
        return this.info.getRemoteRepo();
    }

    @Override
    public Optional<Path> getPomFile() {
        return this.info.getEnhancedMainPomFile();
    }

    public AFCliRequest getReq() {
        return this.req;
    }

    @Override
    public AFCliRequest getKieCliRequest() {
        return this.req;
    }

    @Override
    public String getMavenRepo() {
        return this.mavenRepo;
    }

    public String getRequestUUID() {
        return this.requestUUID;
    }
}

