/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOMavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(NIOMavenUtils.class);
    private static final String POM_NAME = "pom.xml";

    public static List<Artifact> resolveDependenciesFromMultimodulePrj(List<String> pomsPaths) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        ArrayList<Artifact> deps = new ArrayList<Artifact>();
        try {
            for (String pomx : pomsPaths) {
                Path pom = Paths.get(pomx, new String[0]);
                Model model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes(pom)));
                if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
                    NIOMavenUtils.createArtifacts(model.getDependencyManagement().getDependencies(), deps);
                }
                if (model.getDependencies() == null) continue;
                NIOMavenUtils.createArtifacts(model.getDependencies(), deps);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return Collections.emptyList();
        }
        return deps;
    }

    private static void createArtifacts(List<Dependency> pomDeps, List<Artifact> deps) {
        if (pomDeps != null && pomDeps.size() > 0) {
            for (Dependency dep : pomDeps) {
                DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType(), dep.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler());
                deps.add((Artifact)artifact);
            }
        }
    }

    public static void searchPoms(Path file, List<String> pomsList) {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(file.toAbsolutePath());){
            for (Path p : ds) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    NIOMavenUtils.searchPoms(p, pomsList);
                    continue;
                }
                if (!p.endsWith(POM_NAME)) continue;
                pomsList.add(p.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

