/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.dependencies;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.context.ApplicationScoped;
import org.appformer.maven.integration.MavenRepository;
import org.eclipse.aether.artifact.Artifact;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.dependencies.DependencyTestUtils;
import org.kie.workbench.common.services.shared.dependencies.DependencyService;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependency;
import org.kie.workbench.common.services.shared.dependencies.NormalEnhancedDependency;
import org.kie.workbench.common.services.shared.dependencies.TransitiveEnhancedDependency;

@Service
@ApplicationScoped
public class DependencyServiceImpl
implements DependencyService {
    public Collection<Dependency> loadDependencies(Collection<GAV> gavs) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (GAV gav : gavs) {
            dependencies.addAll(this.loadDependencies(gav));
        }
        return dependencies;
    }

    public Collection<Dependency> loadDependencies(GAV gav) {
        return DependencyTestUtils.toDependencies(this.getMavenRepository().getArtifactDependecies(gav.toString()));
    }

    public Set<String> loadPackageNames(GAV gav) {
        Artifact artifact = this.getMavenRepository().resolveArtifact(gav.toString());
        if (artifact != null) {
            return this.stripPackageNamesFromJar(artifact.getFile());
        }
        return new HashSet<String>();
    }

    public EnhancedDependencies loadEnhancedDependencies(Collection<Dependency> dependencies) {
        EnhancedDependencies result = new EnhancedDependencies();
        for (Dependency dependency : dependencies) {
            result.add((EnhancedDependency)this.getEnhancedDependency(dependency));
        }
        return result;
    }

    private NormalEnhancedDependency getEnhancedDependency(Dependency dependency) {
        NormalEnhancedDependency enhancedDependency = new NormalEnhancedDependency(dependency, this.loadPackageNames((GAV)dependency));
        for (Dependency transitiveDependency : this.loadDependencies((GAV)dependency)) {
            enhancedDependency.addTransitiveDependency(new TransitiveEnhancedDependency(transitiveDependency, this.loadPackageNames((GAV)transitiveDependency)));
        }
        return enhancedDependency;
    }

    private Set<String> stripPackageNamesFromJar(File file) {
        HashSet<String> packageNames = new HashSet<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String pathName = entries.nextElement().getName();
                if (!pathName.endsWith(".class")) continue;
                String fqcn = pathName.replace('/', '.').substring(0, pathName.lastIndexOf(46));
                packageNames.add(fqcn.substring(0, fqcn.lastIndexOf(46)));
            }
        }
        catch (IOException e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw ExceptionUtilities.handleException((Exception)e);
                }
            }
        }
        return packageNames;
    }

    protected MavenRepository getMavenRepository() {
        return MavenRepository.getMavenRepository();
    }
}

