/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.kie.workbench.common.services.shared.project.KieModule;

@ApplicationScoped
public class DeploymentVerifier {
    private ModuleRepositoryResolver repositoryResolver;
    private ModuleRepositoriesService moduleRepositoriesService;

    public DeploymentVerifier() {
    }

    @Inject
    public DeploymentVerifier(ModuleRepositoryResolver repositoryResolver, ModuleRepositoriesService moduleRepositoriesService) {
        this.repositoryResolver = repositoryResolver;
        this.moduleRepositoriesService = moduleRepositoriesService;
    }

    public void verifyWithException(Module module, DeploymentMode deploymentMode) {
        if (DeploymentMode.VALIDATED.equals((Object)deploymentMode)) {
            GAV gav = module.getPom().getGav();
            if (gav.isSnapshot()) {
                return;
            }
            ModuleRepositories projectRepositories = (ModuleRepositories)this.moduleRepositoriesService.load(((KieModule)module).getRepositoriesPath());
            Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(gav, module, projectRepositories.filterByIncluded());
            if (repositories.size() > 0) {
                throw new GAVAlreadyExistsException(gav, repositories);
            }
        }
    }
}

