/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.ProjectImportsContent;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class ProjectImportsServiceImpl
extends KieService<ProjectImportsContent>
implements ProjectImportsService {
    protected ProjectConfigurationContentHandler projectConfigurationContentHandler;
    private RenameService renameService;
    private SaveAndRenameServiceImpl<ProjectImports, Metadata> saveAndRenameService;

    public ProjectImportsServiceImpl() {
    }

    @Inject
    public ProjectImportsServiceImpl(@Named(value="ioStrategy") IOService ioService, ProjectConfigurationContentHandler projectConfigurationContentHandler, RenameService renameService, SaveAndRenameServiceImpl<ProjectImports, Metadata> saveAndRenameService) {
        this.ioService = ioService;
        this.projectConfigurationContentHandler = projectConfigurationContentHandler;
        this.renameService = renameService;
        this.saveAndRenameService = saveAndRenameService;
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public void saveProjectImports(org.uberfire.backend.vfs.Path path) {
        if (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path))) {
            throw new FileAlreadyExistsException(path.toString());
        }
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.projectConfigurationContentHandler.toString(this.createProjectImports()), new OpenOption[0]);
    }

    private ProjectImports createProjectImports() {
        ProjectImports projectImports = new ProjectImports();
        Imports imports = projectImports.getImports();
        imports.addImport(new Import(Number.class.getName()));
        imports.addImport(new Import(Boolean.class.getName()));
        imports.addImport(new Import(String.class.getName()));
        imports.addImport(new Import(Integer.class.getName()));
        imports.addImport(new Import(Double.class.getName()));
        imports.addImport(new Import(List.class.getName()));
        imports.addImport(new Import(Collection.class.getName()));
        imports.addImport(new Import(ArrayList.class.getName()));
        return projectImports;
    }

    @Override
    public ProjectImportsContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (ProjectImportsContent)super.loadContent(path);
    }

    @Override
    protected ProjectImportsContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        return new ProjectImportsContent(this.load(path), overview);
    }

    public ProjectImports load(org.uberfire.backend.vfs.Path path) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            if (!this.ioService.exists(nioPath)) {
                this.saveProjectImports(path);
            }
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            ProjectImports projectImports = this.projectConfigurationContentHandler.toModel(content);
            Import javaLangNumber = new Import(Number.class);
            if (projectImports.getImports().getImports().stream().noneMatch(anImport -> Objects.equals(anImport, javaLangNumber))) {
                projectImports.getImports().addImport(javaLangNumber);
            }
            return projectImports;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ProjectImports projectImports, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.projectConfigurationContentHandler.toString(projectImports), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[0]);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, ProjectImports content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

