/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.ala;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.kie.workbench.common.services.backend.builder.ala.LocalBinaryConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfigInternal;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildExecConfig;
import org.kie.workbench.common.services.backend.builder.ala.impl.LocalBuildBinaryImpl;
import org.kie.workbench.common.services.backend.builder.core.BuildHelper;

@ApplicationScoped
public class LocalBuildExecConfigExecutor
implements BiFunctionConfigExecutor<LocalBuildConfigInternal, LocalBuildExecConfig, LocalBinaryConfig> {
    private BuildHelper buildHelper;

    public LocalBuildExecConfigExecutor() {
    }

    @Inject
    public LocalBuildExecConfigExecutor(BuildHelper buildHelper) {
        this.buildHelper = buildHelper;
    }

    public Optional<LocalBinaryConfig> apply(LocalBuildConfigInternal localBuildConfigInternal, LocalBuildExecConfig localBuildExecConfig) {
        Optional<LocalBinaryConfig> result = Optional.empty();
        switch (localBuildConfigInternal.getBuildType()) {
            case FULL_BUILD: {
                BuildHelper.BuildResult buildResult = this.buildHelper.build(localBuildConfigInternal.getProject());
                result = Optional.of(new LocalBuildBinaryImpl(buildResult.getBuilder(), buildResult.getBuildResults()));
                break;
            }
            case INCREMENTAL_ADD_RESOURCE: {
                result = Optional.of(new LocalBuildBinaryImpl(this.buildHelper.addPackageResource(localBuildConfigInternal.getResource())));
                break;
            }
            case INCREMENTAL_UPDATE_RESOURCE: {
                result = Optional.of(new LocalBuildBinaryImpl(this.buildHelper.updatePackageResource(localBuildConfigInternal.getResource())));
                break;
            }
            case INCREMENTAL_DELETE_RESOURCE: {
                result = Optional.of(new LocalBuildBinaryImpl(this.buildHelper.deletePackageResource(localBuildConfigInternal.getResource())));
                break;
            }
            case INCREMENTAL_BATCH_CHANGES: {
                result = Optional.of(new LocalBuildBinaryImpl(this.buildHelper.applyBatchResourceChanges(localBuildConfigInternal.getProject(), localBuildConfigInternal.getResourceChanges())));
                break;
            }
            case FULL_BUILD_AND_DEPLOY: {
                result = Optional.of(new LocalBuildBinaryImpl(this.buildHelper.buildAndDeploy(localBuildConfigInternal.getProject(), localBuildConfigInternal.isSuppressHandlers(), this.toDeploymentMode(localBuildConfigInternal.getDeploymentType()))));
            }
        }
        return result;
    }

    public Class<? extends Config> executeFor() {
        return LocalBuildExecConfig.class;
    }

    public String outputId() {
        return "local-binary";
    }

    private DeploymentMode toDeploymentMode(LocalBuildConfig.DeploymentType deploymentType) {
        return deploymentType == LocalBuildConfig.DeploymentType.VALIDATED ? DeploymentMode.VALIDATED : DeploymentMode.FORCED;
    }
}

