/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.external339.AFMavenCli;
import org.kie.workbench.common.services.backend.compiler.impl.ProcessedPoms;
import org.kie.workbench.common.services.backend.compiler.nio.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.IncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.DefaultIncrementalCompilerEnabler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public abstract class BaseMavenCompiler<T extends CompilationResponse>
implements AFCompiler<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseMavenCompiler.class);
    private AFMavenCli cli = new AFMavenCli();
    private IncrementalCompilerEnabler enabler = new DefaultIncrementalCompilerEnabler(Compilers.JAVAC);

    public static Boolean isValidMavenRepo(Path mavenRepo) {
        if (mavenRepo.getParent() == null) {
            return Boolean.FALSE;
        }
        return Files.exists((Path)mavenRepo, (LinkOption[])new LinkOption[0]) && Files.isDirectory((Path)mavenRepo, (LinkOption[])new LinkOption[0]) && Files.isWritable((Path)mavenRepo) && Files.isReadable((Path)mavenRepo);
    }

    @Override
    public T compileSync(CompilationRequest req) {
        ProcessedPoms processedPoms;
        if (logger.isDebugEnabled()) {
            logger.debug("KieCompilationRequest:{}", (Object)req);
        }
        if (!req.getInfo().getEnhancedMainPomFile().isPresent() && !(processedPoms = this.enabler.process(req)).getResult().booleanValue()) {
            return this.buildDefaultCompilationResponse(Boolean.FALSE, "Processing poms failed", Collections.emptyList());
        }
        req.getKieCliRequest().getRequest().setLocalRepositoryPath(req.getMavenRepo());
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassWorld kieClassWorld = new ClassWorld("plexus.core", this.getClass().getClassLoader());
        int exitCode = this.cli.doMain(req.getKieCliRequest(), kieClassWorld);
        Thread.currentThread().setContextClassLoader(original);
        if (exitCode == 0) {
            return this.buildDefaultCompilationResponse(Boolean.TRUE);
        }
        return this.buildDefaultCompilationResponse(Boolean.FALSE);
    }

    protected abstract T buildDefaultCompilationResponse(Boolean var1, String var2, List<String> var3);
}

