/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationContextProvider;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultPomEditor;
import org.kie.workbench.common.services.backend.compiler.impl.PomPlaceHolder;
import org.kie.workbench.common.services.backend.compiler.impl.ProcessedPoms;
import org.kie.workbench.common.services.backend.compiler.nio.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.IncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.MavenUtils;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

public class DefaultIncrementalCompilerEnabler
implements IncrementalCompilerEnabler {
    private final String POM_NAME = "pom.xml";
    private DefaultPomEditor editor;

    public DefaultIncrementalCompilerEnabler(Compilers compiler) {
        this.editor = new DefaultPomEditor(new HashSet<PomPlaceHolder>(), new ConfigurationContextProvider(), compiler);
    }

    @Override
    public ProcessedPoms process(CompilationRequest req) {
        Path mainPom = Paths.get((String)req.getInfo().getPrjPath().toString(), (String[])new String[]{"pom.xml"});
        if (!Files.isReadable((Path)mainPom)) {
            return new ProcessedPoms(Boolean.FALSE, Collections.emptyList());
        }
        PomPlaceHolder placeHolder = this.editor.readSingle(mainPom);
        Boolean isPresent = this.isPresent(placeHolder);
        if (placeHolder.isValid().booleanValue() && !isPresent.booleanValue()) {
            ArrayList<String> pomsList = new ArrayList<String>();
            MavenUtils.searchPoms(Paths.get((String)req.getInfo().getPrjPath().toString(), (String[])new String[0]), pomsList);
            if (pomsList.size() > 0) {
                this.processFoundPoms(pomsList, req);
            }
            return new ProcessedPoms(Boolean.TRUE, pomsList);
        }
        return new ProcessedPoms(Boolean.FALSE, Collections.emptyList());
    }

    private void processFoundPoms(List<String> poms, CompilationRequest request) {
        for (String pom : poms) {
            Path tmpPom = Paths.get((String)pom, (String[])new String[0]);
            PomPlaceHolder tmpPlaceHolder = this.editor.readSingle(tmpPom);
            if (this.isPresent(tmpPlaceHolder).booleanValue()) continue;
            this.editor.write(tmpPom, request);
        }
        Path mainPom = Paths.get((String)request.getInfo().getPrjPath().toAbsolutePath().toString(), (String[])new String[]{"pom.xml"});
        request.getInfo().lateAdditionEnhancedMainPomFile(mainPom);
    }

    private Boolean isPresent(PomPlaceHolder placeholder) {
        return this.editor.getHistory().contains(placeholder);
    }

    public Set<PomPlaceHolder> getHistory() {
        return Collections.unmodifiableSet(this.editor.getHistory());
    }
}

