/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.builder.ObservablePOMFile;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.project.KieProjectFactory;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceUpdated;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class ProjectRepositoriesSynchronizer {
    private IOService ioService;
    private ProjectRepositoryResolver repositoryResolver;
    private ProjectRepositoriesService projectRepositoriesService;
    private ObservablePOMFile observablePOMFile;
    private KieProjectFactory projectFactory;

    public ProjectRepositoriesSynchronizer() {
    }

    @Inject
    public ProjectRepositoriesSynchronizer(@Named(value="ioStrategy") IOService ioService, ProjectRepositoryResolver repositoryResolver, ProjectRepositoriesService projectRepositoriesService, ObservablePOMFile observablePOMFile, KieProjectFactory projectFactory) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.repositoryResolver = (ProjectRepositoryResolver)PortablePreconditions.checkNotNull((String)"repositoryResolver", (Object)repositoryResolver);
        this.projectRepositoriesService = (ProjectRepositoriesService)PortablePreconditions.checkNotNull((String)"projectRepositoriesService", (Object)projectRepositoriesService);
        this.observablePOMFile = (ObservablePOMFile)PortablePreconditions.checkNotNull((String)"observablePOMFile", (Object)observablePOMFile);
        this.projectFactory = (KieProjectFactory)PortablePreconditions.checkNotNull((String)"projectFactory", (Object)projectFactory);
    }

    public void onResourceUpdated(@Observes ResourceUpdatedEvent event) {
        if (this.observablePOMFile.accept(event.getPath())) {
            this.syncProjectRepositories(event.getPath());
        }
    }

    public void onBatchResourceChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (Map.Entry entry : resourceBatchChangesEvent.getBatch().entrySet()) {
            if (!this.observablePOMFile.accept((org.uberfire.backend.vfs.Path)entry.getKey()) || !this.isUpdate((Collection)entry.getValue())) continue;
            this.syncProjectRepositories((org.uberfire.backend.vfs.Path)entry.getKey());
            break;
        }
    }

    private boolean isUpdate(Collection<ResourceChange> value) {
        for (ResourceChange resourceChange : value) {
            if (!(resourceChange instanceof ResourceUpdated)) continue;
            return true;
        }
        return false;
    }

    private void syncProjectRepositories(org.uberfire.backend.vfs.Path _path) {
        Path path = this.ioService.get(URI.create(_path.toURI()));
        KieProject project = (KieProject)this.projectFactory.simpleProjectInstance(path.getParent());
        ProjectRepositories projectRepositories = (ProjectRepositories)this.projectRepositoriesService.load(project.getRepositoriesPath());
        Set mavenRepositories = this.repositoryResolver.getRemoteRepositoriesMetaData((Project)project);
        HashSet<MavenRepositoryMetadata> existingMavenRepositories = new HashSet<MavenRepositoryMetadata>();
        HashSet<ProjectRepositories.ProjectRepository> repositoriesToRemove = new HashSet<ProjectRepositories.ProjectRepository>();
        for (ProjectRepositories.ProjectRepository projectRepository : projectRepositories.getRepositories()) {
            MavenRepositoryMetadata mavenRepositoryMetadata = projectRepository.getMetadata();
            if (mavenRepositories.contains(mavenRepositoryMetadata)) {
                existingMavenRepositories.add(mavenRepositoryMetadata);
                continue;
            }
            repositoriesToRemove.add(projectRepository);
        }
        HashSet<MavenRepositoryMetadata> repositoriesToAdd = new HashSet<MavenRepositoryMetadata>();
        for (MavenRepositoryMetadata mavenRepositoryMetadata : mavenRepositories) {
            if (existingMavenRepositories.contains(mavenRepositoryMetadata)) continue;
            repositoriesToAdd.add(mavenRepositoryMetadata);
        }
        for (ProjectRepositories.ProjectRepository projectRepository : repositoriesToRemove) {
            projectRepositories.getRepositories().remove(projectRepository);
        }
        for (MavenRepositoryMetadata mavenRepositoryMetadata : repositoriesToAdd) {
            projectRepositories.getRepositories().add(new ProjectRepositories.ProjectRepository(true, mavenRepositoryMetadata));
        }
        this.projectRepositoriesService.save(project.getRepositoriesPath(), projectRepositories, "Automatic synchronization");
    }
}

