/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.rulename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRulesByProjectQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringRuleNamePageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class RuleNameServiceImpl
implements RuleNamesService {
    private RefactoringQueryService queryService;
    private KieProjectService projectService;

    public RuleNameServiceImpl() {
    }

    @Inject
    public RuleNameServiceImpl(RefactoringQueryService queryService, KieProjectService projectService) {
        this.queryService = queryService;
        this.projectService = projectService;
    }

    public Collection<String> getRuleNames(Path path, String packageName) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyList();
        }
        return this.queryRuleNames(packageName, project.getRootPath().toURI());
    }

    private List<String> queryRuleNames(final String packageName, final String projectPath) {
        List results = this.queryService.query(FindRulesByProjectQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueProjectRootPathIndexTerm(projectPath));
                this.add(new ValuePackageNameIndexTerm(packageName));
            }
        });
        return this.convertToRuleNames(results);
    }

    private List<String> convertToRuleNames(List<RefactoringPageRow> results) {
        ArrayList<String> ruleNames = new ArrayList<String>();
        for (RefactoringPageRow row : results) {
            ruleNames.add(((RefactoringRuleNamePageRow.RuleName)row.getValue()).getSimpleRuleName());
        }
        Collections.sort(ruleNames);
        return ruleNames;
    }
}

