/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.healthcheck;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.security.PermitAll;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.workbench.common.services.backend.healthcheck.ServiceCheck;
import org.kie.workbench.common.services.backend.healthcheck.ServiceStatus;

@Path(value="/")
@ApplicationScoped
public class HealthCheckService {
    @Inject
    private Instance<ServiceCheck> services;

    @GET
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="/ready")
    public Response isReady() {
        return this.getResponse(services -> services.allMatch(ServiceStatus::isReady));
    }

    @GET
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="/healthy")
    public Response isHealthy() {
        return this.getResponse(services -> services.allMatch(ServiceStatus::isHealthy));
    }

    private Response getResponse(Function<Stream<ServiceStatus>, Boolean> success) {
        Map<String, ServiceStatus> servicesByStatus = this.getServicesByStatus();
        if (success.apply(servicesByStatus.values().stream()).booleanValue()) {
            return Response.ok((Object)"{\"success\": true}").build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity(servicesByStatus).build();
    }

    Map<String, ServiceStatus> getServicesByStatus() {
        return StreamSupport.stream(this.services.spliterator(), false).collect(Collectors.toMap(ServiceCheck::getName, ServiceCheck::getStatus));
    }
}

