/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.net.URLClassLoader;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.model.Project;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.project.KieProject;

@ApplicationScoped
@Named(value="LRUProjectDependenciesClassLoaderCache")
public class LRUProjectDependenciesClassLoaderCache
extends LRUCache<KieProject, ClassLoader> {
    private BuildInfoService buildInfoService;

    public LRUProjectDependenciesClassLoaderCache() {
    }

    @Inject
    public LRUProjectDependenciesClassLoaderCache(BuildInfoService buildInfoService) {
        this.buildInfoService = buildInfoService;
    }

    protected void setBuildInfoService(BuildInfoService buildInfoService) {
        this.buildInfoService = buildInfoService;
    }

    public ClassLoader assertDependenciesClassLoader(KieProject project) {
        ClassLoader classLoader = (ClassLoader)this.getEntry(project);
        if (classLoader == null) {
            classLoader = this.buildClassLoader(project);
            this.setEntry(project, classLoader);
        }
        return classLoader;
    }

    public void setDependenciesClassLoader(KieProject project, ClassLoader classLoader) {
        this.setEntry(project, classLoader);
    }

    private ClassLoader buildClassLoader(KieProject project) {
        KieModule module = this.buildInfoService.getBuildInfo((Project)project).getKieModuleIgnoringErrors();
        return LRUProjectDependenciesClassLoaderCache.buildClassLoader(project, KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module));
    }

    public static ClassLoader buildClassLoader(KieProject project, KieModuleMetaData kieModuleMetaData) {
        ClassLoader classLoader = kieModuleMetaData.getClassLoader().getParent();
        if (classLoader instanceof URLClassLoader) {
            return classLoader;
        }
        throw new RuntimeException("It was not possible to calculate project dependencies class loader for project: " + project.getKModuleXMLPath());
    }
}

