/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.services.backend.compiler.Order;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationKey;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationEnvironmentStrategy
implements ConfigurationStrategy,
Order {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationEnvironmentStrategy.class);
    protected Map<ConfigurationKey, String> conf;
    private Boolean valid = Boolean.TRUE;

    public ConfigurationEnvironmentStrategy() {
        ConfigurationKey[] keys;
        this.conf = new HashMap<ConfigurationKey, String>();
        Map<String, String> env = System.getenv();
        for (ConfigurationKey key : keys = ConfigurationKey.values()) {
            String value = env.get(key.name());
            if (value == null) {
                logger.info("Key {} not present in the Environment, skip to the next ConfigurationStrategy. \n", (Object)key.name());
                this.valid = Boolean.FALSE;
                break;
            }
            this.conf.put(key, value);
        }
    }

    @Override
    public Integer getOrder() {
        return 0;
    }

    @Override
    public Boolean isValid() {
        return this.valid;
    }

    @Override
    public Map<ConfigurationKey, String> loadConfiguration() {
        return Collections.unmodifiableMap(this.conf);
    }
}

