/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.allowlist;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.file.AntPathMatcher;
import org.kie.workbench.common.services.shared.allowlist.AllowList;

public class PackageNameAllowListFilter {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private final Collection<String> packageNames;
    private final Set<String> patterns;

    public PackageNameAllowListFilter(Collection<String> packageNames, AllowList allowList) {
        this.packageNames = (Collection)PortablePreconditions.checkNotNull((String)"packageNames", packageNames);
        PortablePreconditions.checkNotNull((String)"allowlist", (Object)allowList);
        this.patterns = this.makePatterns(allowList);
    }

    private Set<String> makePatterns(AllowList allowList) {
        HashSet<String> patterns = new HashSet<String>();
        for (String packageName : allowList) {
            patterns.add(packageName.replaceAll("\\.", "/"));
        }
        return patterns;
    }

    public AllowList getFilteredPackageNames() {
        AllowList allowList = new AllowList();
        HashMap<String, String> packageNamePatterns = this.getPatterns();
        for (String pattern : this.patterns) {
            for (Map.Entry packageNamePath : packageNamePatterns.entrySet()) {
                if (!ANT_PATH_MATCHER.match(pattern, (String)packageNamePath.getValue())) continue;
                allowList.add((String)packageNamePath.getKey());
            }
        }
        return allowList;
    }

    private HashMap<String, String> getPatterns() {
        HashMap<String, String> packageNamePaths = new HashMap<String, String>();
        for (String packageName : this.packageNames) {
            packageNamePaths.put(packageName, packageName.replaceAll("\\.", "/"));
        }
        return packageNamePaths;
    }
}

