/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.external339;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.kie.workbench.common.services.backend.compiler.external339.AFCliRequest;
import org.kie.workbench.common.services.backend.compiler.external339.AFConfigurationProcessor;
import org.kie.workbench.common.services.backend.compiler.external339.AFSettingsBuildingRequest;
import org.slf4j.Logger;

@Named
@Component(role=AFConfigurationProcessor.class, hint="settings")
public class AFSettingsXmlConfigurationProcessor
implements AFConfigurationProcessor {
    public static final String HINT = "settings";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final Path USER_MAVEN_CONFIGURATION_HOME = Paths.get(USER_HOME, ".m2");
    public static final Path DEFAULT_USER_SETTINGS_FILE = Paths.get(USER_MAVEN_CONFIGURATION_HOME.toString(), "settings.xml");
    public static final Path DEFAULT_GLOBAL_SETTINGS_FILE = Paths.get(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    @Requirement
    private Logger logger;
    @Requirement
    private SettingsBuilder settingsBuilder;
    @Requirement
    private SettingsDecrypter settingsDecrypter;

    @Override
    public void process(AFCliRequest cliRequest) throws Exception {
        Path globalSettingsFile;
        Path userSettingsFile;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        MavenExecutionRequest request = cliRequest.getRequest();
        if (commandLine.hasOption('s')) {
            userSettingsFile = Paths.get(commandLine.getOptionValue('s'), new String[0]);
            if (!Files.isRegularFile(userSettingsFile = AFSettingsXmlConfigurationProcessor.resolvePath(userSettingsFile, workingDirectory), new LinkOption[0])) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (commandLine.hasOption("gs")) {
            globalSettingsFile = Paths.get(commandLine.getOptionValue("gs"), new String[0]);
            if (!Files.isRegularFile(globalSettingsFile = AFSettingsXmlConfigurationProcessor.resolvePath(globalSettingsFile, workingDirectory), new LinkOption[0])) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        request.setGlobalSettingsFile(globalSettingsFile.toFile());
        request.setUserSettingsFile(userSettingsFile.toFile());
        AFSettingsBuildingRequest settingsRequest = new AFSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile.toFile());
        settingsRequest.setUserSettingsFile(userSettingsFile.toFile());
        settingsRequest.setSystemProperties(cliRequest.getSystemProperties());
        settingsRequest.setUserProperties(cliRequest.getUserProperties());
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsRequest);
        }
        this.logger.debug("Reading global settings from " + this.getLocation((Source)settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsPath()));
        this.logger.debug("Reading user settings from " + this.getLocation((Source)settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsPath()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsResult);
        }
        this.populateFromSettings(request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.logger.warn("");
        }
    }

    private MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile((Profile)rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository((Repository)remoteRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
            List pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepository : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository((Repository)pluginRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
        }
        return request;
    }

    private Object getLocation(Source source, Path defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    static Path resolvePath(Path file, String workingDirectory) {
        return file == null ? null : (file.isAbsolute() ? file : (file.getFileName().startsWith(File.separator) ? file.toAbsolutePath() : Paths.get(workingDirectory, file.getFileName().toString())));
    }
}

