/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.kie.workbench.common.services.backend.compiler.PluginPresents;
import org.kie.workbench.common.services.backend.compiler.PomEditor;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationKey;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationProvider;
import org.kie.workbench.common.services.backend.compiler.configuration.MavenConfig;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultPluginPresents;
import org.kie.workbench.common.services.backend.compiler.impl.PomPlaceHolder;
import org.kie.workbench.common.services.backend.compiler.nio.CompilationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardOpenOption;

public class DefaultPomEditor
implements PomEditor {
    public final String POM = "pom";
    public final String TRUE = "true";
    public final String POM_NAME = "pom.xml";
    public final String KJAR_EXT = "kjar";
    protected final Logger logger = LoggerFactory.getLogger(DefaultPomEditor.class);
    protected Compilers compiler;
    protected Map<ConfigurationKey, String> conf;
    protected MavenXpp3Reader reader;
    protected MavenXpp3Writer writer;
    protected Set<PomPlaceHolder> history;

    public DefaultPomEditor(Set<PomPlaceHolder> history, ConfigurationProvider config, Compilers compiler) {
        this.conf = config.loadConfiguration();
        this.reader = new MavenXpp3Reader();
        this.writer = new MavenXpp3Writer();
        this.history = history;
        this.compiler = compiler;
    }

    @Override
    public Set<PomPlaceHolder> getHistory() {
        return Collections.unmodifiableSet(this.history);
    }

    @Override
    public void cleanHistory() {
        this.history.clear();
    }

    protected PluginPresents updatePom(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            model.setBuild(new Build());
            build = model.getBuild();
        }
        Boolean defaultCompilerPluginPresent = Boolean.FALSE;
        Boolean alternativeCompilerPluginPresent = Boolean.FALSE;
        Boolean kiePluginPresent = Boolean.FALSE;
        int alternativeCompilerPosition = 0;
        int defaultMavenCompilerPosition = 0;
        int kieMavenPluginPosition = 0;
        if (model.getPackaging().equals("kjar")) {
            kiePluginPresent = Boolean.TRUE;
        }
        int i = 0;
        for (Plugin plugin : build.getPlugins()) {
            if (plugin.getGroupId().equals(this.conf.get((Object)ConfigurationKey.MAVEN_PLUGINS)) && plugin.getArtifactId().equals(this.conf.get((Object)ConfigurationKey.MAVEN_COMPILER_PLUGIN))) {
                defaultCompilerPluginPresent = Boolean.TRUE;
                defaultMavenCompilerPosition = i;
            }
            if (plugin.getGroupId().equals(this.conf.get((Object)ConfigurationKey.ALTERNATIVE_COMPILER_PLUGINS)) && plugin.getArtifactId().equals(this.conf.get((Object)ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN))) {
                alternativeCompilerPluginPresent = Boolean.TRUE;
                alternativeCompilerPosition = i;
            }
            if (plugin.getGroupId().equals(this.conf.get((Object)ConfigurationKey.KIE_MAVEN_PLUGINS)) && plugin.getArtifactId().equals(this.conf.get((Object)ConfigurationKey.KIE_MAVEN_PLUGIN))) {
                kiePluginPresent = Boolean.TRUE;
                kieMavenPluginPosition = i;
            }
            ++i;
        }
        Boolean overwritePOM = this.updatePOMModel(build, defaultCompilerPluginPresent, alternativeCompilerPluginPresent, kiePluginPresent, defaultMavenCompilerPosition, alternativeCompilerPosition, kieMavenPluginPosition);
        return new DefaultPluginPresents(defaultCompilerPluginPresent, alternativeCompilerPluginPresent, kiePluginPresent, overwritePOM);
    }

    private Boolean updatePOMModel(Build build, Boolean defaultCompilerPluginPresent, Boolean alternativeCompilerPluginPresent, Boolean kiePluginPresent, int defaultMavenCompilerPosition, int alternativeCompilerPosition, int kieMavenPluginPosition) {
        Boolean overwritePOM = Boolean.FALSE;
        if (!alternativeCompilerPluginPresent.booleanValue()) {
            build.addPlugin(this.getNewCompilerPlugin());
            alternativeCompilerPluginPresent = Boolean.TRUE;
            overwritePOM = Boolean.TRUE;
        }
        if (!defaultCompilerPluginPresent.booleanValue()) {
            Plugin disabledDefaultCompiler = new Plugin();
            disabledDefaultCompiler.setArtifactId(this.conf.get((Object)ConfigurationKey.MAVEN_COMPILER_PLUGIN));
            this.disableMavenCompilerAlreadyPresent(disabledDefaultCompiler);
            build.addPlugin(disabledDefaultCompiler);
            defaultCompilerPluginPresent = Boolean.TRUE;
            overwritePOM = Boolean.TRUE;
        }
        if (defaultCompilerPluginPresent.booleanValue() && alternativeCompilerPluginPresent.booleanValue() && defaultMavenCompilerPosition <= alternativeCompilerPosition) {
            Plugin defaultMavenCompiler = (Plugin)build.getPlugins().get(defaultMavenCompilerPosition);
            Plugin alternativeCompiler = (Plugin)build.getPlugins().get(alternativeCompilerPosition);
            build.getPlugins().set(defaultMavenCompilerPosition, alternativeCompiler);
            build.getPlugins().set(alternativeCompilerPosition, defaultMavenCompiler);
            overwritePOM = Boolean.TRUE;
        }
        return overwritePOM;
    }

    protected Plugin getNewCompilerPlugin() {
        Plugin newCompilerPlugin = new Plugin();
        newCompilerPlugin.setGroupId(this.conf.get((Object)ConfigurationKey.ALTERNATIVE_COMPILER_PLUGINS));
        newCompilerPlugin.setArtifactId(this.conf.get((Object)ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN));
        newCompilerPlugin.setVersion(this.conf.get((Object)ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN_VERSION));
        PluginExecution execution = new PluginExecution();
        execution.setId("compile");
        execution.setGoals(Arrays.asList("compile"));
        execution.setPhase("compile");
        Xpp3Dom compilerId = new Xpp3Dom(MavenConfig.MAVEN_COMPILER_ID);
        compilerId.setValue(this.compiler.name().toLowerCase());
        Xpp3Dom configuration = new Xpp3Dom(MavenConfig.MAVEN_PLUGIN_CONFIGURATION);
        configuration.addChild(compilerId);
        execution.setConfiguration((Object)configuration);
        newCompilerPlugin.setExecutions(Arrays.asList(execution));
        return newCompilerPlugin;
    }

    protected void disableMavenCompilerAlreadyPresent(Plugin plugin) {
        Xpp3Dom skipMain = new Xpp3Dom(MavenConfig.MAVEN_SKIP_MAIN);
        skipMain.setValue("true");
        Xpp3Dom skip = new Xpp3Dom(MavenConfig.MAVEN_SKIP);
        skip.setValue("true");
        Xpp3Dom configuration = new Xpp3Dom(MavenConfig.MAVEN_PLUGIN_CONFIGURATION);
        configuration.addChild(skipMain);
        configuration.addChild(skip);
        plugin.setConfiguration((Object)configuration);
        PluginExecution exec = new PluginExecution();
        exec.setId(MavenConfig.MAVEN_DEFAULT_COMPILE);
        exec.setPhase(MavenConfig.MAVEN_PHASE_NONE);
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        executions.add(exec);
        plugin.setExecutions(executions);
    }

    protected String[] addCreateClasspathMavenArgs(String[] args) {
        StringBuilder sb = new StringBuilder(MavenConfig.MAVEN_DEP_PLUGING_OUTPUT_FILE).append(MavenConfig.CLASSPATH_FILENAME).append(MavenConfig.CLASSPATH_EXT);
        String[] newArgs = Arrays.copyOf(args, args.length + 2);
        newArgs[args.length] = "dependency:build-classpath";
        newArgs[args.length + 1] = sb.toString();
        return newArgs;
    }

    public PomPlaceHolder readSingle(Path pom) {
        PomPlaceHolder holder = new PomPlaceHolder();
        try {
            Model model = this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)pom)));
            holder = new PomPlaceHolder(pom.toAbsolutePath().toString(), model.getArtifactId(), model.getGroupId(), model.getVersion(), model.getPackaging());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return holder;
    }

    public void write(Path pom, CompilationRequest request) {
        try {
            Model model = this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)pom)));
            if (model == null) {
                this.logger.error("Model null from pom file:", (Object)pom.toString());
                return;
            }
            PomPlaceHolder pomPH = new PomPlaceHolder(pom.toAbsolutePath().toString(), model.getArtifactId(), model.getGroupId(), model.getVersion(), model.getPackaging(), Files.readAllBytes((Path)Paths.get((String)pom.toAbsolutePath().toString(), (String[])new String[0])));
            if (!this.history.contains(pomPH)) {
                PluginPresents plugs = this.updatePom(model);
                request.getInfo().lateAdditionKiePluginPresent(plugs.isKiePluginPresent());
                if (plugs.isKiePluginPresent().booleanValue()) {
                    String[] args = this.addCreateClasspathMavenArgs(request.getKieCliRequest().getArgs());
                    request.getKieCliRequest().setArgs(args);
                }
                if (plugs.pomOverwriteRequired().booleanValue()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.writer.write((OutputStream)baos, model);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Pom changed:{}", (Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    }
                    Path pomParent = Paths.get((String)pom.getParent().toAbsolutePath().toString(), (String[])new String[]{"pom.xml"});
                    Files.delete((Path)pomParent, (DeleteOption[])new DeleteOption[0]);
                    Files.write((Path)pomParent, (byte[])baos.toByteArray(), (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE_NEW});
                }
                this.history.add(pomPH);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }
}

