/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio;

import java.util.Optional;
import org.uberfire.java.nio.file.Path;

public class WorkspaceCompilationInfo {
    protected Path prjPath;
    protected Path enhancedMainPomFile;
    protected Boolean kiePluginPresent = Boolean.FALSE;

    public WorkspaceCompilationInfo(Path prjPath) {
        this.prjPath = prjPath;
    }

    public Boolean lateAdditionEnhancedMainPomFile(Path enhancedPom) {
        if (this.enhancedMainPomFile == null && enhancedPom != null) {
            this.enhancedMainPomFile = enhancedPom;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionKiePluginPresent(Boolean present) {
        if (this.kiePluginPresent == null && present != null) {
            this.kiePluginPresent = present;
            return Boolean.TRUE;
        }
        if (present != null) {
            this.kiePluginPresent = this.kiePluginPresent | present;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isKiePluginPresent() {
        return this.kiePluginPresent;
    }

    public Path getPrjPath() {
        return this.prjPath;
    }

    public Optional<Path> getEnhancedMainPomFile() {
        return Optional.ofNullable(this.enhancedMainPomFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkspaceCompilationInfo{");
        sb.append("prjPath:{").append(this.prjPath);
        sb.append("}, enhancedMainPomFile:{").append(this.enhancedMainPomFile);
        sb.append('}');
        return sb.toString();
    }
}

