/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.decorators;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.JGitUtils;
import org.kie.workbench.common.services.backend.compiler.nio.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.WorkspaceCompilationInfo;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.CompilerDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.DefaultCompilationRequest;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGITCompilerBeforeDecorator<T extends CompilationResponse, C extends AFCompiler<T>>
implements CompilerDecorator {
    private Map<JGitFileSystem, Git> gitMap = new HashMap<JGitFileSystem, Git>();
    private C compiler;

    public JGITCompilerBeforeDecorator(C compiler) {
        this.compiler = compiler;
    }

    @Override
    public T compileSync(CompilationRequest _req) {
        CompilationRequest req;
        Path path = _req.getInfo().getPrjPath();
        if (path.getFileSystem() instanceof JGitFileSystem) {
            Git repo;
            JGitFileSystem fs = (JGitFileSystem)path.getFileSystem();
            if (!this.gitMap.containsKey(fs)) {
                repo = JGitUtils.tempClone(fs, _req.getRequestUUID());
                this.gitMap.put(fs, repo);
            }
            repo = this.gitMap.get(fs);
            JGitUtils.applyBefore(repo);
            req = new DefaultCompilationRequest(_req.getMavenRepo(), new WorkspaceCompilationInfo(Paths.get((URI)repo.getRepository().getDirectory().toPath().getParent().resolve(path.getFileName().toString()).normalize().toUri())), _req.getOriginalArgs(), _req.getMap(), _req.getLogRequested());
        } else {
            req = _req;
        }
        return this.compiler.compileSync(req);
    }

    @Override
    public T buildDefaultCompilationResponse(Boolean value) {
        return this.compiler.buildDefaultCompilationResponse(value);
    }

    @Override
    public T buildDefaultCompilationResponse(Boolean value, List output) {
        return this.compiler.buildDefaultCompilationResponse(value);
    }
}

