/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.nio.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.JGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.OutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.DefaultMavenCompiler;

public class MavenCompilerFactory {
    private static Map<String, AFCompiler> compilers = new ConcurrentHashMap<String, AFCompiler>();

    private MavenCompilerFactory() {
    }

    public static AFCompiler getCompiler(Decorator decorator) {
        AFCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = MavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static AFCompiler createAndAddNewCompiler(Decorator decorator) {
        AFCompiler<CompilationResponse> compiler;
        switch (decorator) {
            case NONE: {
                compiler = new DefaultMavenCompiler();
                break;
            }
            case JGIT_BEFORE: {
                compiler = new JGITCompilerBeforeDecorator(new DefaultMavenCompiler());
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new OutputLogAfterDecorator(new DefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new JGITCompilerBeforeDecorator(new OutputLogAfterDecorator(new DefaultMavenCompiler()));
                break;
            }
            default: {
                compiler = new DefaultMavenCompiler();
            }
        }
        compilers.put(Decorator.NONE.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, AFCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

