/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl.kie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.KieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.configuration.KieDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.JGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.KieAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.OutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.kie.KieDefaultMavenCompiler;

public class KieMavenCompilerFactory {
    private static Map<String, AFCompiler> compilers = new ConcurrentHashMap<String, AFCompiler>();

    private KieMavenCompilerFactory() {
    }

    public static AFCompiler getCompiler(KieDecorator decorator) {
        AFCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = KieMavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static AFCompiler createAndAddNewCompiler(KieDecorator decorator) {
        AFCompiler<KieCompilationResponse> compiler;
        switch (decorator) {
            case NONE: {
                compiler = new KieDefaultMavenCompiler();
                break;
            }
            case KIE_AFTER: {
                compiler = new KieAfterDecorator(new KieDefaultMavenCompiler());
                break;
            }
            case KIE_AND_LOG_AFTER: {
                compiler = new KieAfterDecorator(new OutputLogAfterDecorator(new KieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE: {
                compiler = new JGITCompilerBeforeDecorator(new KieDefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new JGITCompilerBeforeDecorator(new OutputLogAfterDecorator(new KieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE_AND_KIE_AFTER: {
                compiler = new JGITCompilerBeforeDecorator(new KieAfterDecorator(new KieDefaultMavenCompiler()));
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new OutputLogAfterDecorator(new KieDefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_KIE_AND_LOG_AFTER: {
                compiler = new JGITCompilerBeforeDecorator(new KieAfterDecorator(new OutputLogAfterDecorator(new KieDefaultMavenCompiler())));
                break;
            }
            default: {
                compiler = new KieDefaultMavenCompiler();
            }
        }
        compilers.put(Decorator.NONE.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, AFCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

