/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.kmodule.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import org.drools.core.util.AbstractXStreamConverter;
import org.kie.workbench.common.services.shared.kmodule.AssertBehaviorOption;
import org.kie.workbench.common.services.shared.kmodule.DeclarativeAgendaOption;
import org.kie.workbench.common.services.shared.kmodule.EventProcessingOption;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.KSessionModel;

public class KBaseConverter
extends AbstractXStreamConverter {
    public KBaseConverter() {
        super(KBaseModel.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        KBaseModel kBase = (KBaseModel)value;
        writer.addAttribute("name", kBase.getName());
        writer.addAttribute("default", Boolean.toString(kBase.isDefault()));
        if (kBase.getEventProcessingMode() != null) {
            writer.addAttribute("eventProcessingMode", kBase.getEventProcessingMode().getMode());
        }
        if (kBase.getEqualsBehavior() != null) {
            writer.addAttribute("equalsBehavior", kBase.getEqualsBehavior().toString());
        }
        if (kBase.getDeclarativeAgenda() != null) {
            writer.addAttribute("declarativeAgenda", kBase.getDeclarativeAgenda().toString());
        }
        if (kBase.getScope() != null) {
            writer.addAttribute("scope", kBase.getScope());
        }
        if (!kBase.getPackages().isEmpty()) {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (String pkg : kBase.getPackages()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(pkg);
            }
            writer.addAttribute("packages", buf.toString());
        }
        if (!kBase.getIncludes().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean insertComma = false;
            for (String include : kBase.getIncludes()) {
                if (insertComma) {
                    sb.append(", ");
                }
                sb.append(include);
                if (insertComma) continue;
                insertComma = true;
            }
            writer.addAttribute("includes", sb.toString());
        }
        for (KSessionModel kSessionModel : kBase.getKSessions()) {
            this.writeObject(writer, context, "ksession", kSessionModel);
        }
    }

    private void setTypes(String stateful, Map<String, KSessionModel> sessions) {
        for (String key : sessions.keySet()) {
            sessions.get(key).setType(stateful);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
        String includes;
        String pkgs;
        String scope;
        String declarativeAgenda;
        String equalsBehavior;
        final KBaseModel kBase = new KBaseModel();
        kBase.setName(reader.getAttribute("name"));
        kBase.setDefault("true".equals(reader.getAttribute("default")));
        String eventMode = reader.getAttribute("eventProcessingMode");
        if (eventMode != null) {
            kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
        }
        if ((equalsBehavior = reader.getAttribute("equalsBehavior")) != null) {
            kBase.setEqualsBehavior(AssertBehaviorOption.determineAssertBehaviorMode((String)equalsBehavior));
        }
        if ((declarativeAgenda = reader.getAttribute("declarativeAgenda")) != null) {
            kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgendaMode((String)declarativeAgenda));
        }
        if ((scope = reader.getAttribute("scope")) != null) {
            kBase.setScope(scope.trim());
        }
        if ((pkgs = reader.getAttribute("packages")) != null) {
            for (String pkg : pkgs.split(",")) {
                kBase.addPackage(pkg.trim());
            }
        }
        if ((includes = reader.getAttribute("includes")) != null) {
            for (String include : includes.split(",")) {
                kBase.addInclude(include.trim());
            }
        }
        this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

            public void onNode(HierarchicalStreamReader reader, String name, String value) {
                if ("ksession".equals(name)) {
                    KSessionModel kSession = (KSessionModel)KBaseConverter.this.readObject(reader, context, KSessionModel.class);
                    kBase.getKSessions().add(kSession);
                } else if ("includes".equals(name)) {
                    for (String include : KBaseConverter.this.readList(reader)) {
                        kBase.addInclude(include);
                    }
                }
            }
        });
        return kBase;
    }
}

