/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoImpl;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.validation.asset.NoModuleException;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorResultBuilder;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ValidatorBuildService {
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found. Consequentially validation cannot be performed.\nPlease check the necessary external dependencies for this module are configured correctly.";
    private IOService ioService;
    private LRUBuilderCache builderCache;
    private KieModuleService moduleService;
    private BuildInfoService buildInfoService;

    public ValidatorBuildService() {
    }

    @Inject
    public ValidatorBuildService(@Named(value="ioStrategy") IOService ioService, LRUBuilderCache builderCache, KieModuleService moduleService, BuildInfoService buildInfoService) {
        this.ioService = ioService;
        this.builderCache = builderCache;
        this.moduleService = moduleService;
        this.buildInfoService = buildInfoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath, String content) {
        ByteArrayInputStream inputStream = null;
        try {
            List<ValidationMessage> results;
            inputStream = new ByteArrayInputStream(content.getBytes(Charsets.UTF_8));
            List<ValidationMessage> list = results = this.doValidation(resourcePath, inputStream);
            return list;
        }
        catch (NoModuleException e) {
            ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            return arrayList;
        }
        catch (NoClassDefFoundError e) {
            ArrayList<ValidationMessage> arrayList = this.error(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage()));
            return arrayList;
        }
        catch (Throwable e2) {
            ArrayList<ValidationMessage> arrayList;
            block20: {
                arrayList = this.error(e2.getLocalizedMessage());
                if (inputStream == null) break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath) {
        InputStream inputStream = null;
        try {
            List<ValidationMessage> results;
            inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)resourcePath), new OpenOption[0]);
            List<ValidationMessage> list = results = this.doValidation(resourcePath, inputStream);
            return list;
        }
        catch (NoModuleException e) {
            ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            return arrayList;
        }
        catch (NoClassDefFoundError e) {
            ArrayList<ValidationMessage> arrayList = this.error(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage()));
            return arrayList;
        }
        catch (Throwable e2) {
            ArrayList<ValidationMessage> arrayList;
            block20: {
                arrayList = this.error(e2.getLocalizedMessage());
                if (inputStream == null) break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<ValidationMessage> doValidation(org.uberfire.backend.vfs.Path resourcePath, InputStream inputStream) throws NoModuleException {
        ValidatorResultBuilder resultBuilder = new ValidatorResultBuilder();
        Module module = this.module(resourcePath);
        Path nioResourcePath = Paths.convert((org.uberfire.backend.vfs.Path)resourcePath);
        if (this.isIncrementalBuildPossible(resourcePath)) {
            BuildInfo buildInfo = this.buildInfoService.getBuildInfo(module);
            Builder clone = ((BuildInfoImpl)buildInfo).getBuilder().clone();
            clone.deleteResource(nioResourcePath);
            IncrementalBuildResults incrementalBuildResults = clone.updateResource(nioResourcePath, inputStream);
            resultBuilder.add(incrementalBuildResults.getAddedMessages());
        } else {
            Builder builder = this.builderCache.assertBuilder(this.module(resourcePath));
            Builder clone = builder.clone();
            resultBuilder.add(clone.build(nioResourcePath, inputStream).getMessages());
        }
        return resultBuilder.results();
    }

    private boolean isIncrementalBuildPossible(org.uberfire.backend.vfs.Path resourcePath) throws NoModuleException {
        return this.getDestinationPath(resourcePath).startsWith("src/main/resources/");
    }

    private String getDestinationPath(org.uberfire.backend.vfs.Path originalPath) throws NoModuleException {
        return Paths.removePrefix((org.uberfire.backend.vfs.Path)originalPath, (org.uberfire.backend.vfs.Path)this.module(originalPath).getRootPath());
    }

    private Module module(org.uberfire.backend.vfs.Path resourcePath) throws NoModuleException {
        Module module = this.moduleService.resolveModule(resourcePath);
        if (module == null) {
            throw new NoModuleException();
        }
        return module;
    }

    private ArrayList<ValidationMessage> error(final String errorMessage) {
        return new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage(Level.ERROR, errorMessage));
            }
        };
    }
}

