/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.verifier.service;

import java.util.ArrayList;
import javax.enterprise.inject.Instance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerProvider;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerRegistry;
import org.mockito.Mockito;

public class VerifierWebWorkerRegistryTest {
    @Test
    public void noWebWorkerProviders() throws Exception {
        Instance verifierWebWorkerProviders = (Instance)Mockito.mock(Instance.class);
        ((Instance)Mockito.doReturn(new ArrayList().iterator()).when((Object)verifierWebWorkerProviders)).iterator();
        Assert.assertFalse((boolean)new VerifierWebWorkerRegistry(verifierWebWorkerProviders).get("something").isPresent());
    }

    @Test
    public void wrongId() throws Exception {
        Instance verifierWebWorkerProviders = (Instance)Mockito.mock(Instance.class);
        ArrayList<VerifierWebWorkerProvider> webWorkerProviders = new ArrayList<VerifierWebWorkerProvider>();
        webWorkerProviders.add(this.getWebWorkerProvider("somethingElse"));
        ((Instance)Mockito.doReturn(webWorkerProviders.iterator()).when((Object)verifierWebWorkerProviders)).iterator();
        Assert.assertFalse((boolean)new VerifierWebWorkerRegistry(verifierWebWorkerProviders).get("something").isPresent());
    }

    @Test
    public void correctId() throws Exception {
        Instance verifierWebWorkerProviders = (Instance)Mockito.mock(Instance.class);
        ArrayList<VerifierWebWorkerProvider> webWorkerProviders = new ArrayList<VerifierWebWorkerProvider>();
        webWorkerProviders.add(this.getWebWorkerProvider("something"));
        ((Instance)Mockito.doReturn(webWorkerProviders.iterator()).when((Object)verifierWebWorkerProviders)).iterator();
        Assert.assertTrue((boolean)new VerifierWebWorkerRegistry(verifierWebWorkerProviders).get("something").isPresent());
    }

    private VerifierWebWorkerProvider getWebWorkerProvider(final String id) {
        return new VerifierWebWorkerProvider(){

            public String getId() {
                return id;
            }

            public String getWebWorker(String fileName) throws Exception {
                return "";
            }
        };
    }
}

