/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.verifier.service;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerProvider;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerRegistry;
import org.kie.workbench.common.services.verifier.service.VerifierWebWorkerServlet;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class VerifierWebWorkerServletTest {
    @Mock
    private HttpServletRequest httpServletRequest;
    @Mock
    private HttpServletResponse httpServletResponse;
    @Mock
    private ServletOutputStream servletOutputStream;
    @Mock
    VerifierWebWorkerRegistry verifierWebWorkerRegistry;
    @InjectMocks
    private VerifierWebWorkerServlet servlet;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.httpServletResponse.getOutputStream()).thenReturn((Object)this.servletOutputStream);
    }

    @Test
    public void loadMainFile() throws Exception {
        VerifierWebWorkerProvider verifierWebWorkerProvider = (VerifierWebWorkerProvider)Mockito.mock(VerifierWebWorkerProvider.class);
        ((VerifierWebWorkerProvider)Mockito.doReturn((Object)"").when((Object)verifierWebWorkerProvider)).getWebWorker("/dtableVerifier/VerifierWebWorker.nocache.js");
        ((VerifierWebWorkerRegistry)Mockito.doReturn(Optional.of(verifierWebWorkerProvider)).when((Object)this.verifierWebWorkerRegistry)).get("dtableVerifier");
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"/verifier/dtableVerifier/VerifierWebWorker.nocache.js");
        this.downloadStarts();
    }

    @Test
    public void loadActualWebWorkerFile() throws Exception {
        VerifierWebWorkerProvider verifierWebWorkerProvider = (VerifierWebWorkerProvider)Mockito.mock(VerifierWebWorkerProvider.class);
        ((VerifierWebWorkerProvider)Mockito.doReturn((Object)"").when((Object)verifierWebWorkerProvider)).getWebWorker("/dtableVerifier/0BD650E7DC9A4B57B8AFCE8F27AACA84.cache.js");
        ((VerifierWebWorkerRegistry)Mockito.doReturn(Optional.of(verifierWebWorkerProvider)).when((Object)this.verifierWebWorkerRegistry)).get("dtableVerifier");
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"/verifier/dtableVerifier/0BD650E7DC9A4B57B8AFCE8F27AACA84.cache.js");
        this.downloadStarts();
    }

    @Test
    public void fileNameNeedsToContainVerifier() throws Exception {
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"0BD650E7DC9A4B57B8AFCE8F27AACA84.cache.js");
        this.downloadDoesNotStart();
    }

    @Test
    public void fileNameNeedsToEndWithNoCacheJS() throws Exception {
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"/verifier/dtableVerifier/0BD650E7DC9A4B57B8AFCE8F27AACA84.cache");
        this.downloadDoesNotStart();
    }

    @Test
    public void idNeedsToBeFound() throws Exception {
        VerifierWebWorkerProvider verifierWebWorkerProvider = (VerifierWebWorkerProvider)Mockito.mock(VerifierWebWorkerProvider.class);
        ((VerifierWebWorkerProvider)Mockito.doReturn((Object)"").when((Object)verifierWebWorkerProvider)).getWebWorker("/dtableVerifier/0BD650E7DC9A4B57B8AFCE8F27AACA84.cache.js");
        ((VerifierWebWorkerRegistry)Mockito.doReturn(Optional.of(verifierWebWorkerProvider)).when((Object)this.verifierWebWorkerRegistry)).get("dtableVerifier");
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"/verifier/someOtherVerifierId/0BD650E7DC9A4B57B8AFCE8F27AACA84.cache");
        this.downloadDoesNotStart();
    }

    private void downloadStarts() throws ServletException, IOException {
        this.servlet.doGet(this.httpServletRequest, this.httpServletResponse);
        ((HttpServletResponse)Mockito.verify((Object)this.httpServletResponse)).getOutputStream();
    }

    private void downloadDoesNotStart() throws ServletException, IOException {
        this.servlet.doGet(this.httpServletRequest, this.httpServletResponse);
        ((HttpServletResponse)Mockito.verify((Object)this.httpServletResponse, (VerificationMode)Mockito.never())).getOutputStream();
    }
}

