/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingMessage;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingMessageDecorator;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingRequest;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.validation.Violation;

public class Match<In, Out> {
    private final LinkedList<Case> cases = new LinkedList();
    private final LinkedList<Case> strictCases = new LinkedList();
    private Function<In, Out> orElse;
    private Out defaultValue;
    private Optional<MarshallingMessageDecorator> inputDecorator = Optional.empty();
    private Optional<MarshallingMessageDecorator> outputDecorator = Optional.empty();
    private MarshallingRequest.Mode mode = MarshallingRequest.Mode.AUTO;

    public static <In, Out> Match<In, Out> of() {
        return new Match<In, Out>();
    }

    public static <In, Out> Match<In, Node<? extends View<? extends Out>, ?>> ofNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>();
    }

    public static <In, Out> Match<Node<? extends View<?>, ?>, Out> fromNode(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>();
    }

    public static <In, Out> Match<In, Edge<? extends View<? extends Out>, ?>> ofEdge(Class<In> inputType, Class<Out> outputType) {
        return new Match<In, Out>();
    }

    private static <T, U> Function<T, Result<U>> reportMissing(Class<?> expectedClass) {
        return t -> Result.failure("Not yet implemented: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()), new MarshallingMessage[0]);
    }

    private <T extends In> Function<T, Result<Out>> ignored(Class<?> expectedClass) {
        return t -> Result.ignored("Ignored: " + Optional.ofNullable(t).map(o -> o.getClass().getCanonicalName()).orElse("null -- expected " + expectedClass.getCanonicalName()), this.defaultValue, MarshallingMessage.builder().message("Ignored " + t).build());
    }

    public <T extends In> Match<In, Out> when(Function<?, Boolean> type, Function<T, Out> then) {
        Function<Object, Result> thenWrapped = sub -> Result.of(then.apply(sub), new MarshallingMessage[0]);
        return this.when_(type, thenWrapped);
    }

    private <T extends In> Match<In, Out> when_(Function<?, Boolean> type, Function<T, Result<Out>> then) {
        this.cases.add(new Case(type, then));
        return this;
    }

    public <T extends In> Match<In, Out> missing(Function<In, Boolean> type, Class<T> clazz) {
        return this.when_(type, Match.reportMissing(clazz));
    }

    public <T extends In> Match<In, Out> ignore(Function<T, Boolean> type, Class<T> clazz) {
        return this.when_(type, this.ignored(clazz));
    }

    public Match<In, Out> orElse(Function<In, Out> then) {
        this.orElse = then;
        return this;
    }

    public Match<In, Out> inputDecorator(MarshallingMessageDecorator<In> decorator) {
        this.inputDecorator = Optional.ofNullable(decorator);
        return this;
    }

    public Match<In, Out> outputDecorator(MarshallingMessageDecorator<Out> decorator) {
        this.outputDecorator = Optional.ofNullable(decorator);
        return this;
    }

    public Match<In, Out> defaultValue(Out value) {
        this.defaultValue = value;
        return this;
    }

    public Match<In, Out> mode(MarshallingRequest.Mode mode) {
        this.mode = mode;
        return this;
    }

    private <T extends In> Result<Out> apply(T value, List<Case> cases, Supplier<Result<Out>> fallback) {
        return cases.stream().map(c -> c.match(value)).filter(Result::isSuccess).findFirst().orElseGet(fallback);
    }

    public <T extends In> Result<Out> apply(T value) {
        return this.apply(value, this.strictCases, () -> this.apply(value, this.cases, () -> this.applyFallback(value)));
    }

    private <T extends In> Result<Out> applyFallback(T value) {
        if (MarshallingRequest.Mode.ERROR.equals((Object)this.mode)) {
            return this.getFailure(value);
        }
        if (this.orElse == null || MarshallingRequest.Mode.IGNORE.equals((Object)this.mode)) {
            return Stream.concat(this.cases.stream(), this.strictCases.stream()).map(c -> c.match(value)).filter(Result::isIgnored).map(r -> {
                if (r.value() instanceof Result) {
                    ((Result)r.value()).setMessages(this.getIgnoreMessage(value));
                }
                return r;
            }).findFirst().orElseGet(() -> Result.failure(value == null ? "Null value" : value.getClass().getName(), this.defaultValue, this.getIgnoreMessage(value)));
        }
        Out result = this.orElse.apply(value);
        return Result.of(result, MarshallingMessage.builder().message("Converted element: " + value + "to: " + result).messageKey("MarshallingMessage.convertedElement").messageArguments(this.getValueName(value, this.inputDecorator), this.getValueType(value, this.inputDecorator), this.getValueType(result, this.outputDecorator)).type(Violation.Type.WARNING).build());
    }

    private <T extends In> MarshallingMessage getIgnoreMessage(T value) {
        return MarshallingMessage.builder().message("Ignored element " + value).messageKey("MarshallingMessage.ignoredElement").messageArguments(this.getValueName(value, this.inputDecorator), this.getValueType(value, this.inputDecorator)).type(Violation.Type.WARNING).build();
    }

    private Result<Out> getFailure(Object value) {
        return Result.failure(value.getClass().getName(), this.defaultValue, MarshallingMessage.builder().type(Violation.Type.ERROR).message("Failure there is no match for element " + value).messageKey("MarshallingMessage.elementFailure").messageArguments(String.valueOf(value)).build());
    }

    private <T> String getValueType(T value, Optional<MarshallingMessageDecorator> decorator) {
        return decorator.map(d -> d.getType(value)).orElseGet(() -> Optional.ofNullable(value).map(Object::getClass).map(Class::getSimpleName).orElse(""));
    }

    private <T extends In> String getValueName(T value, Optional<MarshallingMessageDecorator> decorator) {
        return decorator.map(d -> d.getName(value)).orElseGet(() -> String.valueOf(value));
    }

    private class Case<In> {
        public final Function<In, Boolean> when;
        public final Function<In, Result<Out>> then;

        private Case(Function<In, Boolean> when, Function<In, Result<Out>> then) {
            this.when = when;
            this.then = then;
        }

        public Result<Out> match(In value) {
            return this.when.apply(value) != false ? this.then.apply(value) : Match.this.getFailure(value);
        }
    }
}

