/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingMessage;

public interface Result<T> {
    public static <R> Result<R> of(R value, MarshallingMessage ... messages) {
        return Result.success(value, messages);
    }

    public static <R> Result<R> success(R value, MarshallingMessage ... messages) {
        return new Success<R>(value, messages);
    }

    public static <R> Result<R> failure(String reason, MarshallingMessage ... messages) {
        return new Failure(reason, messages);
    }

    public static <R> Result<R> failure(String reason, R defaultValue, MarshallingMessage ... messages) {
        return new Failure<R>(reason, defaultValue, messages);
    }

    public static <U> Result<U> ignored(String reason, MarshallingMessage ... messages) {
        return new Ignored(reason, messages);
    }

    public static <U> Result<U> ignored(String reason, U defaultValue, MarshallingMessage ... messages) {
        return new Ignored<U>(reason, defaultValue, messages);
    }

    public boolean isFailure();

    public boolean isIgnored();

    public boolean isSuccess();

    default public boolean nonFailure() {
        return !this.isFailure();
    }

    default public boolean notIgnored() {
        return !this.isIgnored();
    }

    public T value();

    public List<MarshallingMessage> messages();

    public Result<T> setMessages(MarshallingMessage ... var1);

    default public void ifSuccess(Consumer<T> consumer) {
        Optional.ofNullable(this.value()).ifPresent(consumer::accept);
    }

    default public void ifFailure(Consumer<String> consumer) {
        if (this.isFailure()) {
            consumer.accept(this.asFailure().reason());
        }
    }

    public Success<T> asSuccess();

    public Failure<T> asFailure();

    public Ignored<T> asIgnored();

    public static class Failure<T>
    extends AbstractResult<T> {
        private final String reason;
        private final T defaultValue;

        Failure(String reason, MarshallingMessage ... messages) {
            this(reason, null, messages);
        }

        Failure(String reason, T defaultValue, MarshallingMessage ... messages) {
            super(messages);
            this.reason = reason;
            this.defaultValue = defaultValue;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public Success<T> asSuccess() {
            throw new NoSuchElementException(this.reason);
        }

        @Override
        public Ignored<T> asIgnored() {
            throw new ClassCastException("Could not convert Failure to Ignored");
        }

        @Override
        public Failure<T> asFailure() {
            return this;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public T value() {
            return this.defaultValue;
        }
    }

    public static class Ignored<T>
    extends AbstractResult<T> {
        private final String reason;
        private final T defaultValue;

        Ignored(String reason, MarshallingMessage ... messages) {
            this(reason, null, messages);
        }

        Ignored(String reason, T defaultValue, MarshallingMessage ... messages) {
            super(messages);
            this.reason = reason;
            this.defaultValue = defaultValue;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public Success<T> asSuccess() {
            throw new NoSuchElementException(this.reason);
        }

        @Override
        public Ignored<T> asIgnored() {
            return this;
        }

        @Override
        public Failure<T> asFailure() {
            throw new ClassCastException("Could not convert Ignored to Success");
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isIgnored() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public T value() {
            return this.defaultValue;
        }
    }

    public static class Success<T>
    extends AbstractResult<T> {
        private final T value;

        Success(T value, MarshallingMessage ... messages) {
            super(messages);
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public Success<T> asSuccess() {
            return this;
        }

        @Override
        public Ignored<T> asIgnored() {
            throw new ClassCastException("Could not convert Success to Ignored");
        }

        @Override
        public Failure<T> asFailure() {
            throw new ClassCastException("Could not convert Success to Failure");
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return false;
        }
    }

    public static abstract class AbstractResult<T>
    implements Result<T> {
        private List<MarshallingMessage> messages = new ArrayList<MarshallingMessage>();

        AbstractResult(MarshallingMessage ... messages) {
            this.messages.addAll(Arrays.asList(messages));
        }

        @Override
        public List<MarshallingMessage> messages() {
            return this.messages;
        }

        @Override
        public Result<T> setMessages(MarshallingMessage ... messages) {
            this.messages = Stream.of(messages).collect(Collectors.toList());
            return this;
        }
    }
}

