/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties;

import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Task;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.BooleanInput;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomInputDefinition;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.StringInput;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;

public class CustomInput<T> {
    public static final CustomInputDefinition<String> taskName = new StringInput("TaskName", "Task");
    public static final CustomInputDefinition<String> priority = new StringInput("Priority", "");
    public static final CustomInputDefinition<String> subject = new StringInput("Comment", "");
    public static final CustomInputDefinition<String> description = new StringInput("Description", "");
    public static final CustomInputDefinition<String> createdBy = new StringInput("CreatedBy", "");
    public static final CustomInputDefinition<String> groupId = new StringInput("GroupId", "");
    public static final CustomInputDefinition<Boolean> skippable = new BooleanInput("Skippable", false);
    public static final CustomInputDefinition<String> content = new StringInput("Content", "");
    public static final CustomInputDefinition<String> namespace = new StringInput("namespace", "java.lang.String", "");
    public static final CustomInputDefinition<String> dmnModelName = new StringInput("model", "java.lang.String", "");
    public static final CustomInputDefinition<String> decisionName = new StringInput("decision", "java.lang.String", "");
    public static final CustomInputDefinition<String> notStartedReassign = new StringInput("NotStartedReassign", "");
    public static final CustomInputDefinition<String> notCompletedReassign = new StringInput("NotCompletedReassign", "");
    public static final CustomInputDefinition<String> notStartedNotify = new StringInput("NotStartedNotify", "");
    public static final CustomInputDefinition<String> notCompletedNotify = new StringInput("NotCompletedNotify", "");
    private final CustomInputDefinition<T> inputDefinition;
    private final Task element;
    private final ItemDefinition typeDef;

    public CustomInput(CustomInputDefinition<T> inputDefinition, Task element) {
        this.inputDefinition = inputDefinition;
        this.element = element;
        this.typeDef = this.typedefInput(inputDefinition.name(), inputDefinition.type());
    }

    public ItemDefinition typeDef() {
        return this.typeDef;
    }

    public T get() {
        return this.inputDefinition.getValue(this.element);
    }

    public void set(T value) {
        this.setStringValue(String.valueOf(value));
    }

    private void setStringValue(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        DataInputAssociation input = this.input(value);
        DataInput targetRef = (DataInput)input.getTargetRef();
        this.getIoSpecification(this.element).getDataInputs().add((Object)targetRef);
        ((InputSet)this.getIoSpecification(this.element).getInputSets().get(0)).getDataInputRefs().add((Object)targetRef);
        this.element.getDataInputAssociations().add((Object)input);
    }

    private InputOutputSpecification getIoSpecification(Task element) {
        EList inputSets;
        InputOutputSpecification ioSpecification = element.getIoSpecification();
        if (ioSpecification == null) {
            ioSpecification = Factories.bpmn2.createInputOutputSpecification();
            element.setIoSpecification(ioSpecification);
        }
        if ((inputSets = ioSpecification.getInputSets()).isEmpty()) {
            inputSets.add(Factories.bpmn2.createInputSet());
        }
        return ioSpecification;
    }

    private DataInputAssociation input(Object value) {
        DataInput target = this.readInputFrom(this.inputDefinition.name(), this.typeDef);
        Assignment assignment = this.assignment(value.toString(), target.getId());
        DataInputAssociation association = this.associationOf(assignment, target);
        return association;
    }

    private DataInput readInputFrom(String targetName, ItemDefinition typeDef) {
        DataInput dataInput = Factories.bpmn2.createDataInput();
        dataInput.setName(targetName);
        dataInput.setId(Ids.dataInput(this.element.getId(), targetName));
        dataInput.setItemSubjectRef(typeDef);
        CustomAttribute.dtype.of((BaseElement)dataInput).set(typeDef.getStructureRef());
        return dataInput;
    }

    private Assignment assignment(String from, String to) {
        Assignment assignment = Factories.bpmn2.createAssignment();
        FormalExpression fromExpr = Factories.bpmn2.createFormalExpression();
        FormalExpressionBodyHandler.of(fromExpr).setBody(Scripts.asCData(from));
        assignment.setFrom((Expression)fromExpr);
        FormalExpression toExpr = Factories.bpmn2.createFormalExpression();
        FormalExpressionBodyHandler.of(toExpr).setBody(Scripts.asCData(to));
        assignment.setTo((Expression)toExpr);
        return assignment;
    }

    private DataInputAssociation associationOf(Assignment assignment, DataInput dataInput) {
        DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
        dataInputAssociation.getAssignment().add((Object)assignment);
        dataInputAssociation.setTargetRef((ItemAwareElement)dataInput);
        return dataInputAssociation;
    }

    private ItemDefinition typedefInput(String name, String type) {
        ItemDefinition typeDef = Factories.bpmn2.createItemDefinition();
        typeDef.setId(Ids.dataInputItem(this.element.getId(), name));
        typeDef.setStructureRef(type);
        return typeDef;
    }
}

