/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties;

import com.google.gwt.http.client.URL;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.FormalExpressionBodyHandler;

public abstract class InitializedVariable {
    private final String identifier;
    private final String type;
    private ItemDefinition itemDefinition;

    public InitializedVariable(String parentId, VariableDeclaration varDecl) {
        this.identifier = varDecl.getIdentifier();
        this.type = varDecl.getType();
        this.itemDefinition = Factories.bpmn2.createItemDefinition();
        this.itemDefinition.setId(Ids.item(parentId));
        this.itemDefinition.setStructureRef(this.getType());
    }

    public static InitializedInputVariable inputOf(String parentId, VariableScope variableScope, VariableDeclaration varDecl, AssociationDeclaration associationDeclaration) {
        if (associationDeclaration == null) {
            return new InputEmpty(parentId, varDecl);
        }
        AssociationDeclaration.Type type = associationDeclaration.getType();
        switch (type) {
            case FromTo: {
                if (associationDeclaration.getTarget() == null) {
                    return new InputEmpty(parentId, varDecl);
                }
                return new InputConstant(parentId, varDecl, associationDeclaration.getSource());
            }
            case SourceTarget: {
                return new InputVariableReference(parentId, variableScope, varDecl, associationDeclaration.getSource());
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public static InitializedOutputVariable outputOf(String parentId, VariableScope variableScope, VariableDeclaration varDecl, AssociationDeclaration associationDeclaration) {
        if (associationDeclaration == null) {
            return new OutputEmpty(parentId, varDecl);
        }
        AssociationDeclaration.Type type = associationDeclaration.getType();
        switch (type) {
            case FromTo: {
                if (associationDeclaration.getTarget() == null) {
                    return new OutputEmpty(parentId, varDecl);
                }
                throw new IllegalArgumentException("Cannot assign constant to output variable");
            }
            case SourceTarget: {
                return new OutputVariableReference(parentId, variableScope, varDecl, associationDeclaration.getTarget());
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.type;
    }

    public ItemDefinition getItemDefinition() {
        return this.itemDefinition;
    }

    private static DataInput dataInputOf(String parentId, String identifier, String name, ItemDefinition itemDefinition) {
        DataInput dataInput = Factories.bpmn2.createDataInput();
        dataInput.setId(Ids.dataInput(parentId, identifier));
        dataInput.setName(name);
        dataInput.setItemSubjectRef(itemDefinition);
        CustomAttribute.dtype.of((BaseElement)dataInput).set(itemDefinition.getStructureRef());
        return dataInput;
    }

    private static DataOutput dataOutputOf(String parentId, String identifier, String name, ItemDefinition itemDefinition) {
        DataOutput dataOutput = Factories.bpmn2.createDataOutput();
        dataOutput.setId(Ids.dataOutput(parentId, identifier));
        dataOutput.setName(name);
        dataOutput.setItemSubjectRef(itemDefinition);
        CustomAttribute.dtype.of((BaseElement)dataOutput).set(itemDefinition.getStructureRef());
        return dataOutput;
    }

    private static DataOutputAssociation associationOf(Property source, DataOutput dataOutput) {
        DataOutputAssociation dataOutputAssociation = Factories.bpmn2.createDataOutputAssociation();
        dataOutputAssociation.getSourceRef().add((Object)dataOutput);
        dataOutputAssociation.setTargetRef((ItemAwareElement)source);
        return dataOutputAssociation;
    }

    public static class OutputEmpty
    extends InitializedOutputVariable {
        public OutputEmpty(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
        }

        @Override
        public DataOutputAssociation getDataOutputAssociation() {
            return null;
        }
    }

    public static class InputConstant
    extends InitializedInputVariable {
        final String expression;

        public InputConstant(String parentId, VariableDeclaration varDecl, String expression) {
            super(parentId, varDecl);
            this.expression = expression;
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
            Assignment assignment = Factories.bpmn2.createAssignment();
            String id = this.getDataInput().getId();
            FormalExpression toExpr = Factories.bpmn2.createFormalExpression();
            FormalExpressionBodyHandler.of(toExpr).setBody(id);
            assignment.setTo((Expression)toExpr);
            FormalExpression fromExpr = Factories.bpmn2.createFormalExpression();
            String decodedExpression = this.decode(this.expression);
            String cdataExpression = Scripts.asCData(decodedExpression);
            FormalExpressionBodyHandler.of(fromExpr).setBody(cdataExpression);
            assignment.setFrom((Expression)fromExpr);
            dataInputAssociation.getAssignment().add((Object)assignment);
            dataInputAssociation.setTargetRef((ItemAwareElement)this.getDataInput());
            return dataInputAssociation;
        }

        private String decode(String text) {
            return URL.decode((String)text);
        }
    }

    public static class InputEmpty
    extends InitializedInputVariable {
        public InputEmpty(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            return null;
        }
    }

    public static class OutputVariableReference
    extends InitializedOutputVariable {
        private final DataOutput dataOutput;
        private final String targetVariable;
        private final VariableScope scope;

        public OutputVariableReference(String parentId, VariableScope scope, VariableDeclaration varDecl, String targetVariable) {
            super(parentId, varDecl);
            this.scope = scope;
            this.targetVariable = targetVariable;
            this.dataOutput = InitializedVariable.dataOutputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        @Override
        public DataOutput getDataOutput() {
            return this.dataOutput;
        }

        @Override
        public DataOutputAssociation getDataOutputAssociation() {
            return this.scope.lookup(this.targetVariable).map(variable -> InitializedVariable.associationOf(variable.getTypedIdentifier(), this.dataOutput)).orElse(null);
        }
    }

    public static class InputVariableReference
    extends InitializedInputVariable {
        private final String sourceVariable;
        private final VariableScope scope;

        public InputVariableReference(String parentId, VariableScope variableScope, VariableDeclaration varDecl, String sourceVariable) {
            super(parentId, varDecl);
            this.scope = variableScope;
            this.sourceVariable = sourceVariable;
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
            return this.scope.lookup(this.sourceVariable).map(variable -> dataInputAssociation.getSourceRef().add((Object)variable.getTypedIdentifier())).map(added -> {
                dataInputAssociation.setTargetRef((ItemAwareElement)this.getDataInput());
                return added;
            }).map(added -> dataInputAssociation).orElse(null);
        }
    }

    public static abstract class InitializedOutputVariable
    extends InitializedVariable {
        private final DataOutput dataOutput;

        public InitializedOutputVariable(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
            this.getItemDefinition().setId(Ids.dataOutputItem(parentId, varDecl.getIdentifier()));
            this.dataOutput = InitializedVariable.dataOutputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        public DataOutput getDataOutput() {
            return this.dataOutput;
        }

        public abstract DataOutputAssociation getDataOutputAssociation();
    }

    public static abstract class InitializedInputVariable
    extends InitializedVariable {
        private final DataInput dataInput;

        public InitializedInputVariable(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
            this.getItemDefinition().setId(Ids.dataInputItem(parentId, varDecl.getIdentifier()));
            this.dataInput = InitializedVariable.dataInputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        public DataInput getDataInput() {
            return this.dataInput;
        }

        public abstract DataInputAssociation getDataInputAssociation();
    }
}

