/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.elements;

import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomElement;

public abstract class ElementDefinition<T> {
    private final T defaultValue;
    private final String name;

    public ElementDefinition(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String name() {
        return this.name;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract T getValue(BaseElement var1);

    public abstract void setValue(BaseElement var1, T var2);

    protected Optional<String> getStringValue(BaseElement element) {
        return Optional.ofNullable(ElementDefinition.getMetaDataValue((List<ExtensionAttributeValue>)element.getExtensionValues(), this.name));
    }

    protected abstract void setStringValue(BaseElement var1, String var2);

    protected FeatureMap getExtensionElements(BaseElement element) {
        if (element.getExtensionValues() == null || element.getExtensionValues().isEmpty()) {
            ExtensionAttributeValue eav = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
            element.getExtensionValues().add((Object)eav);
            return eav.getValue();
        }
        return ((ExtensionAttributeValue)element.getExtensionValues().get(0)).getValue();
    }

    public CustomElement<T> of(BaseElement element) {
        return new CustomElement(this, element);
    }

    private static String getMetaDataValue(List<ExtensionAttributeValue> extensionValues, String metaDataName) {
        if (extensionValues != null) {
            return extensionValues.stream().map(ExtensionAttributeValue::getValue).flatMap(extensionElements -> {
                List o = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                return o.stream();
            }).filter(metaType -> ElementDefinition.isMetaType((MetaDataType)metaType, metaDataName)).findFirst().map(m -> ((MetaDataType)m).getMetaValue()).orElse(null);
        }
        return null;
    }

    private static boolean isMetaType(MetaDataType metaType, String metaDataName) {
        return metaType.getName() != null && metaType.getName().equals(metaDataName) && metaType.getMetaValue() != null && metaType.getMetaValue().length() > 0;
    }
}

