/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner;

import org.eclipse.bpmn2.Definitions;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes.RootProcessConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.DefinitionsPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class DefinitionsConverter {
    private final ConverterFactory converterFactory;
    private final PropertyWriterFactory propertyWriterFactory;
    private final RootProcessConverter processConverter;

    public DefinitionsConverter(ConverterFactory converterFactory, PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
        this.converterFactory = converterFactory;
        this.processConverter = converterFactory.processConverter();
    }

    public DefinitionsConverter(Graph graph) {
        this.propertyWriterFactory = new PropertyWriterFactory();
        this.converterFactory = new ConverterFactory(new DefinitionsBuildingContext((Graph<DefinitionSet, Node<View<? extends BPMNViewDefinition>, Edge<ViewConnector<BPMNViewDefinition>, Node<? extends View<? extends BPMNViewDefinition>, ?>>>>)graph), this.propertyWriterFactory);
        this.processConverter = this.converterFactory.processConverter();
    }

    public Definitions toDefinitions() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        DefinitionsPropertyWriter p = this.propertyWriterFactory.of(definitions);
        ProcessPropertyWriter pp = this.processConverter.convertProcess();
        p.setExporter("jBPM Process Modeler");
        p.setExporterVersion("2.0");
        p.setProcess(pp.getProcess());
        p.setDiagram(pp.getBpmnDiagram());
        p.setRelationship(pp.getRelationship());
        p.addAllRootElements(pp.getItemDefinitions());
        p.addAllRootElements(pp.getRootElements());
        p.addAllRootElements(pp.getInterfaces());
        return definitions;
    }
}

