/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.events;

import org.eclipse.bpmn2.CatchEvent;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.CatchEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.ConverterUtils;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class IntermediateCatchEventConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public IntermediateCatchEventConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toFlowElement(Node<View<BaseCatchingIntermediateEvent>, ?> node) {
        BaseCatchingIntermediateEvent def = (BaseCatchingIntermediateEvent)((View)node.getContent()).getDefinition();
        if (def instanceof IntermediateMessageEventCatching) {
            return this.messageEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateSignalEventCatching) {
            return this.signalEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateErrorEventCatching) {
            return this.errorEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateTimerEvent) {
            return this.timerEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateConditionalEvent) {
            return this.conditionalEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateEscalationEvent) {
            return this.escalationEvent(ConverterUtils.cast(node));
        }
        if (def instanceof IntermediateCompensationEvent) {
            return this.compensationEvent(ConverterUtils.cast(node));
        }
        return ConverterUtils.notSupported(def);
    }

    private PropertyWriter errorEvent(Node<View<IntermediateErrorEventCatching>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateErrorEventCatching definition = (IntermediateErrorEventCatching)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        CancellingErrorEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addError(executionSet.getErrorRef());
        return p;
    }

    private PropertyWriter signalEvent(Node<View<IntermediateSignalEventCatching>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateSignalEventCatching definition = (IntermediateSignalEventCatching)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        CancellingSignalEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addSignal(definition.getExecutionSet().getSignalRef());
        return p;
    }

    private PropertyWriter timerEvent(Node<View<IntermediateTimerEvent>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateTimerEvent definition = (IntermediateTimerEvent)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        CancellingTimerEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addTimer(executionSet.getTimerSettings());
        return p;
    }

    private PropertyWriter messageEvent(Node<View<IntermediateMessageEventCatching>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateMessageEventCatching definition = (IntermediateMessageEventCatching)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        CancellingMessageEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addMessage(executionSet.getMessageRef());
        return p;
    }

    private PropertyWriter conditionalEvent(Node<View<IntermediateConditionalEvent>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateConditionalEvent definition = (IntermediateConditionalEvent)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        CancellingConditionalEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addCondition(executionSet.getConditionExpression());
        return p;
    }

    private PropertyWriter escalationEvent(Node<View<IntermediateEscalationEvent>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateEscalationEvent definition = (IntermediateEscalationEvent)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        CancellingEscalationEventExecutionSet executionSet = definition.getExecutionSet();
        p.setCancelActivity(executionSet.getCancelActivity().getValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addEscalation(executionSet.getEscalationRef());
        return p;
    }

    private PropertyWriter compensationEvent(Node<View<IntermediateCompensationEvent>, ?> n) {
        CatchEventPropertyWriter p = this.createCatchEventPropertyWriter(n);
        p.getFlowElement().setId(n.getUUID());
        IntermediateCompensationEvent definition = (IntermediateCompensationEvent)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        BaseCancellingEventExecutionSet executionSet = definition.getExecutionSet();
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addCompensation();
        return p;
    }

    private CatchEventPropertyWriter createCatchEventPropertyWriter(Node<? extends View, ?> n) {
        return PropertyWriterUtils.getDockSourceNode(n).isPresent() ? this.propertyWriterFactory.of(Factories.bpmn2.createBoundaryEvent()) : this.propertyWriterFactory.of((CatchEvent)Factories.bpmn2.createIntermediateCatchEvent());
    }
}

