/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.gateways;

import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.GatewayPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.util.ConverterUtils;
import org.kie.workbench.common.stunner.bpmn.definition.BaseGateway;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.GatewayExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class GatewayConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public GatewayConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toFlowElement(Node<View<BaseGateway>, ?> node) {
        BaseGateway def = (BaseGateway)((View)node.getContent()).getDefinition();
        if (def instanceof ParallelGateway) {
            return this.parallel(ConverterUtils.cast(node));
        }
        if (def instanceof ExclusiveGateway) {
            return this.exclusive(ConverterUtils.cast(node));
        }
        if (def instanceof InclusiveGateway) {
            return this.inclusive(ConverterUtils.cast(node));
        }
        if (def instanceof EventGateway) {
            return this.event(ConverterUtils.cast(node));
        }
        return ConverterUtils.notSupported(def);
    }

    private PropertyWriter inclusive(Node<View<InclusiveGateway>, ?> n) {
        GatewayPropertyWriter p = this.propertyWriterFactory.of((Gateway)Factories.bpmn2.createInclusiveGateway());
        p.setId(n.getUUID());
        InclusiveGateway definition = (InclusiveGateway)((View)n.getContent()).getDefinition();
        p.setGatewayDirection(n);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        GatewayExecutionSet executionSet = definition.getExecutionSet();
        p.setDefaultRoute(executionSet.getDefaultRoute().getValue());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter exclusive(Node<View<ExclusiveGateway>, ?> n) {
        GatewayPropertyWriter p = this.propertyWriterFactory.of((Gateway)Factories.bpmn2.createExclusiveGateway());
        p.setId(n.getUUID());
        ExclusiveGateway definition = (ExclusiveGateway)((View)n.getContent()).getDefinition();
        p.setGatewayDirection(n);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        GatewayExecutionSet executionSet = definition.getExecutionSet();
        p.setDefaultRoute(executionSet.getDefaultRoute().getValue());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter parallel(Node<View<ParallelGateway>, ?> n) {
        GatewayPropertyWriter p = this.propertyWriterFactory.of((Gateway)Factories.bpmn2.createParallelGateway());
        p.setId(n.getUUID());
        ParallelGateway definition = (ParallelGateway)((View)n.getContent()).getDefinition();
        p.setGatewayDirection(n);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter event(Node<View<EventGateway>, ?> n) {
        GatewayPropertyWriter p = this.propertyWriterFactory.of((Gateway)Factories.bpmn2.createEventBasedGateway());
        p.setId(n.getUUID());
        p.setGatewayDirection(GatewayDirection.DIVERGING);
        EventGateway definition = (EventGateway)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setAbsoluteBounds(n);
        return p;
    }
}

