/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.lanes;

import org.eclipse.bpmn2.Lane;
import org.kie.workbench.common.stunner.bpmn.client.marshall.MarshallingMessage;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.LanePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class LaneConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public LaneConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public Result<LanePropertyWriter> toElement(Node<View<? extends BPMNViewDefinition>, ?> node) {
        BPMNViewDefinition def = (BPMNViewDefinition)((View)node.getContent()).getDefinition();
        if (def instanceof org.kie.workbench.common.stunner.bpmn.definition.Lane) {
            org.kie.workbench.common.stunner.bpmn.definition.Lane definition = (org.kie.workbench.common.stunner.bpmn.definition.Lane)def;
            Lane lane = Factories.bpmn2.createLane();
            lane.setId(node.getUUID());
            LanePropertyWriter p = this.propertyWriterFactory.of(lane);
            BPMNGeneralSet general = definition.getGeneral();
            p.setName(general.getName().getValue());
            p.setDocumentation(general.getDocumentation().getValue());
            p.setAbsoluteBounds(node);
            return Result.success(p, new MarshallingMessage[0]);
        }
        return Result.ignored("not a lane", new MarshallingMessage[0]);
    }
}

