/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.Result;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.lanes.LaneConverter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.BoundaryEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.LanePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

class ProcessConverterDelegate {
    private final ConverterFactory converterFactory;

    ProcessConverterDelegate(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    void convertChildNodes(ElementContainer p, DefinitionsBuildingContext context) {
        List subprocesses = context.nodes().map(this.converterFactory.subProcessConverter()::convertSubProcess).filter(Result::notIgnored).map(Result::value).collect(Collectors.toList());
        Set<String> processed = subprocesses.stream().flatMap(sub -> sub.getChildElements().stream().map(BasePropertyWriter::getId)).collect(Collectors.toSet());
        subprocesses.stream().filter(e -> !processed.contains(e.getId())).forEach(p::addChildElement);
        context.nodes().filter(e -> !processed.contains(e.getUUID())).map(this.converterFactory.viewDefinitionConverter()::toFlowElement).filter(Result::notIgnored).map(Result::value).forEach(p::addChildElement);
        this.convertLanes(context, processed, p);
    }

    private void convertLanes(DefinitionsBuildingContext context, Set<String> processed, ElementContainer p) {
        LaneConverter laneConverter = this.converterFactory.laneConverter();
        List<LanePropertyWriter> convertedLanes = context.lanes().map(laneConverter::toElement).filter(Result::isSuccess).map(Result::value).peek(convertedLane -> context.withRootNode(convertedLane.getId()).childNodes().filter(n -> !processed.contains(n.getUUID())).forEach(n -> p.getChildElement(n.getUUID()).setParent((BasePropertyWriter)convertedLane))).collect(Collectors.toList());
        p.addLaneSet(convertedLanes);
    }

    void convertEdges(ElementContainer p, DefinitionsBuildingContext context) {
        context.dockEdges().forEach(e -> {
            ActivityPropertyWriter pSrc = (ActivityPropertyWriter)p.getChildElement(e.getSourceNode().getUUID());
            BoundaryEventPropertyWriter pTgt = (BoundaryEventPropertyWriter)p.getChildElement(e.getTargetNode().getUUID());
            if (pTgt != null) {
                pTgt.setParentActivity(pSrc);
            }
        });
        context.edges().map(e -> this.converterFactory.edgeElementConverter().toFlowElement((Edge<?, ?>)e, p)).filter(Result::isSuccess).map(Result::value).forEach(p::addChildElement);
    }

    void postConvertChildNodes(ProcessPropertyWriter processWriter, DefinitionsBuildingContext context) {
        Map<String, BasePropertyWriter> propertyWriters = this.collectPropertyWriters(processWriter);
        context.nodes().forEach(node -> this.converterFactory.flowElementPostConverter().postConvert(processWriter, (BasePropertyWriter)propertyWriters.get(node.getUUID()), (Node<View<? extends BPMNViewDefinition>, ?>)node));
    }

    private Map<String, BasePropertyWriter> collectPropertyWriters(ElementContainer container) {
        Map<String, BasePropertyWriter> result = container.getChildElements().stream().collect(Collectors.toMap(BasePropertyWriter::getId, p -> p));
        container.getChildElements().stream().filter(e -> e instanceof ElementContainer).map(e -> (ElementContainer)((Object)e)).map(this::collectPropertyWriters).collect(Collectors.toList()).forEach(result::putAll);
        return result;
    }
}

