/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes;

import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.BaseDiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessData;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public class RootProcessConverter {
    private final ProcessConverterDelegate delegate;
    private final DefinitionsBuildingContext context;
    private final PropertyWriterFactory propertyWriterFactory;

    public RootProcessConverter(DefinitionsBuildingContext context, PropertyWriterFactory propertyWriterFactory, ConverterFactory converterFactory) {
        this.delegate = new ProcessConverterDelegate(converterFactory);
        this.context = context;
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public ProcessPropertyWriter convertProcess() {
        ProcessPropertyWriter processRoot = this.convertProcessNode(this.context.firstNode());
        this.delegate.convertChildNodes(processRoot, this.context);
        this.delegate.convertEdges(processRoot, this.context);
        this.delegate.postConvertChildNodes(processRoot, this.context);
        return processRoot;
    }

    private ProcessPropertyWriter convertProcessNode(Node<Definition<BPMNDiagram>, ?> node) {
        Process process = Factories.bpmn2.createProcess();
        process.setProcessType(ProcessType.PUBLIC);
        ProcessPropertyWriter p = this.propertyWriterFactory.of(process);
        BPMNDiagram definition = (BPMNDiagram)((Definition)node.getContent()).getDefinition();
        BaseDiagramSet diagramSet = definition.getDiagramSet();
        p.setName(diagramSet.getName().getValue());
        p.setDocumentation(diagramSet.getDocumentation().getValue());
        p.setId(diagramSet.getId().getValue());
        p.setPackage(diagramSet.getPackageProperty().getValue());
        p.setType(diagramSet.getProcessType().getValue());
        p.setVersion(diagramSet.getVersion().getValue());
        p.setAdHoc(diagramSet.getAdHoc().getValue());
        p.setDescription(diagramSet.getProcessInstanceDescription().getValue());
        p.setGlobalVariables(diagramSet.getGlobalVariables());
        p.setExecutable(diagramSet.getExecutable().getValue());
        p.setSlaDueDate(diagramSet.getSlaDueDate());
        BaseProcessData processData = definition.getProcessData();
        p.setProcessVariables(processData.getProcessVariables());
        CaseIdPrefix caseIdPrefix = definition.getCaseManagementSet().getCaseIdPrefix();
        p.setCaseIdPrefix(caseIdPrefix);
        CaseRoles caseRoles = definition.getCaseManagementSet().getCaseRoles();
        p.setCaseRoles(caseRoles);
        CaseFileVariables caseFileVariables = definition.getCaseManagementSet().getCaseFileVariables();
        p.setCaseFileVariables(caseFileVariables);
        return p;
    }
}

