/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import bpsim.ElementParameters;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.AssignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.tostunner.properties.SimulationSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;

public class ActivityPropertyWriter
extends PropertyWriter {
    protected final Activity activity;
    private ElementParameters simulationParameters;

    public ActivityPropertyWriter(Activity activity, VariableScope variableScope) {
        super((FlowElement)activity, variableScope);
        this.activity = activity;
    }

    public Activity getFlowElement() {
        return this.activity;
    }

    public void setSimulationSet(SimulationSet simulationSet) {
        this.simulationParameters = SimulationSets.toElementParameters(simulationSet);
        this.simulationParameters.setElementRef(this.activity.getId());
    }

    @Override
    public ElementParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    public void setAssignmentsInfo(AssignmentsInfo info) {
        List<InitializedVariable.InitializedOutputVariable> outputs;
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.of(info);
        List<InitializedVariable.InitializedInputVariable> inputs = assignmentsInfo.createInitializedInputVariables(this.getId(), this.variableScope);
        if (!inputs.isEmpty()) {
            InputOutputSpecification ioSpec = this.getIoSpecification();
            for (InitializedVariable.InitializedInputVariable input : inputs) {
                if (AssignmentsInfos.isReservedIdentifier(input.getIdentifier())) continue;
                DataInput dataInput = input.getDataInput();
                this.getInputSet(ioSpec).getDataInputRefs().add((Object)dataInput);
                ioSpec.getDataInputs().add((Object)dataInput);
                this.addItemDefinition(input.getItemDefinition());
                DataInputAssociation dataInputAssociation = input.getDataInputAssociation();
                if (dataInputAssociation == null) continue;
                this.activity.getDataInputAssociations().add((Object)dataInputAssociation);
            }
        }
        if (!(outputs = assignmentsInfo.createInitializedOutputVariables(this.getId(), this.variableScope)).isEmpty()) {
            InputOutputSpecification ioSpec = this.getIoSpecification();
            for (InitializedVariable.InitializedOutputVariable output : outputs) {
                DataOutput dataOutput = output.getDataOutput();
                this.getOutputSet(ioSpec).getDataOutputRefs().add((Object)dataOutput);
                ioSpec.getDataOutputs().add((Object)dataOutput);
                this.addItemDefinition(output.getItemDefinition());
                DataOutputAssociation dataOutputAssociation = output.getDataOutputAssociation();
                if (dataOutputAssociation == null) continue;
                this.activity.getDataOutputAssociations().add((Object)dataOutputAssociation);
            }
        }
    }

    protected InputOutputSpecification getIoSpecification() {
        InputOutputSpecification ioSpecification = this.activity.getIoSpecification();
        if (ioSpecification == null) {
            ioSpecification = Factories.bpmn2.createInputOutputSpecification();
            this.activity.setIoSpecification(ioSpecification);
        }
        return ioSpecification;
    }

    protected InputSet getInputSet(InputOutputSpecification ioSpecification) {
        InputSet inputSet;
        EList inputSets = ioSpecification.getInputSets();
        if (inputSets.isEmpty()) {
            inputSet = Factories.bpmn2.createInputSet();
            inputSets.add(inputSet);
        } else {
            inputSet = (InputSet)inputSets.get(0);
        }
        return inputSet;
    }

    protected OutputSet getOutputSet(InputOutputSpecification ioSpecification) {
        OutputSet outputSet;
        EList outputSets = ioSpecification.getOutputSets();
        if (outputSets.isEmpty()) {
            outputSet = Factories.bpmn2.createOutputSet();
            outputSets.add(outputSet);
        } else {
            outputSet = (OutputSet)outputSets.get(0);
        }
        return outputSet;
    }
}

