/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties;

import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.ActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.CatchEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.client.marshall.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class BoundaryEventPropertyWriter
extends CatchEventPropertyWriter {
    private final BoundaryEvent event;

    public BoundaryEventPropertyWriter(BoundaryEvent event, VariableScope variableScope) {
        super((CatchEvent)event, variableScope);
        this.event = event;
    }

    @Override
    public void setCancelActivity(Boolean value) {
        CustomAttribute.boundarycaForEvent.of((BaseElement)this.flowElement).set(value);
        this.event.setCancelActivity(value.booleanValue());
    }

    public void setParentActivity(ActivityPropertyWriter parent) {
        this.event.setAttachedToRef(parent.getFlowElement());
    }

    @Override
    public void addEventDefinition(EventDefinition eventDefinition) {
        this.event.getEventDefinitions().add((Object)eventDefinition);
    }

    @Override
    public void setAbsoluteBounds(Node<? extends View, ?> node) {
        Bound ul = ((View)node.getContent()).getBounds().getUpperLeft();
        this.setDockerInfo(Point2D.create((double)ul.getX(), (double)ul.getY()));
        Optional<Node<View, Edge>> dockSourceNode = PropertyWriterUtils.getDockSourceNode(node);
        if (dockSourceNode.isPresent()) {
            Bounds dockSourceNodeBounds = BoundaryEventPropertyWriter.absoluteBounds(dockSourceNode.get());
            Bounds nodeBounds = ((View)node.getContent()).getBounds();
            double x = dockSourceNodeBounds.getX() + nodeBounds.getUpperLeft().getX();
            double y = dockSourceNodeBounds.getY() + nodeBounds.getUpperLeft().getY();
            super.setBounds(Bounds.create((double)x, (double)y, (double)(x + nodeBounds.getWidth()), (double)(y + nodeBounds.getHeight())));
        } else {
            super.setAbsoluteBounds(node);
        }
    }

    private void setDockerInfo(Point2D docker) {
        CustomAttribute.dockerInfo.of((BaseElement)this.event).set(docker);
    }
}

